﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
namespace nn {
namespace audio {
namespace detail {

enum UacConnectionType : int32_t
{
    UacConnectionType_Speaker = 0,
    UacConnectionType_Microphone,
};

enum UacEventType : int16_t
{
    UacEventType_Attach = 0,
    UacEventType_Detach,
    UacEventType_MicrophoneUpdate,
    UacEventType_SpeakerUpdate,
    UacEventType_ProcessGmix,
    UacEventType_StateChange,
    UacEventType_CloseAttachThread,
    UacEventType_CheckDeferredLinks,
};

enum UacStateChangeType : int16_t
{
    UacStateChangeType_SetSpeakerSource,
};

typedef int UacSessionId;
static const UacSessionId InvalidUacId = -1;

typedef int ConnectionId;
static const ConnectionId InvalidConnectionId = -1;

}  // namespace detail
}  // namespace audio
}  // namespace nn
