﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#pragma warning( push )
#pragma warning ( disable : 4668 )
#include <audioclient.h>
#pragma warning( pop )

namespace std {

template<>
struct default_delete<IMMDeviceCollection>
{
    void operator()(IMMDeviceCollection* p) const
    {
        p->Release();
    }
};

template<>
struct default_delete<IAudioClient>
{
    void operator()(IAudioClient* p) const
    {
        p->Release();
    }
};

template<>
struct default_delete<IMMDevice>
{
    void operator()(IMMDevice* p) const
    {
        p->Release();
    }
};

template<>
struct default_delete<WAVEFORMATEXTENSIBLE>
{
    void operator()(WAVEFORMATEXTENSIBLE* p) const
    {
        CoTaskMemFree(p);
    }
};

}  // namespace std

