﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nne/audio/audio_GlobalMix.h>
#include <nn/audio/audio_AudioInTypes.h>
#include "../audio_AudioSession.h"
#include "audio_AudioUacDriver.h"

namespace nn {
namespace audio {
namespace detail {

class AudioUacInSession : public AudioSession<nn::audio::detail::AudioUacDriver, nn::audio::AudioInBufferCountMax, nne::audio::gmix::NumAudioInBuffers>
{
public:
    AudioUacInSession(int32_t sessionId, nn::os::SystemEvent& releaseClientBufferEvent) NN_NOEXCEPT;
    virtual ~AudioUacInSession() NN_NOEXCEPT;
    virtual const char* GetDefaultName() NN_NOEXCEPT;
    virtual Result IsSupported(const char* name, const server::SessionFormat& format) NN_NOEXCEPT;
    AudioInState GetState() NN_NOEXCEPT;
    void SetName(const char* name, int length) NN_NOEXCEPT;
    float GetDeviceGain() NN_NOEXCEPT;
    Result SetDeviceGain(float gain) NN_NOEXCEPT;
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
