﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>  // std::min
#include <memory>
#include <mutex>  // std::lock_guard

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_TimeSpan.h>
#include <nn/audio/detail/audio_Log.h>

#include "audio_AudioRecordSession-os.win32.h"

namespace nn { namespace audio { namespace server {

void InitializeFinalOutputRecorder(nn::os::SemaphoreType* pSemaphore, nn::os::EventType* pEventSemaphore) NN_NOEXCEPT
{
    NN_UNUSED(pSemaphore);
    NN_UNUSED(pEventSemaphore);
}

void FinalizeFinalOutputRecorder() NN_NOEXCEPT
{
}

} //namespace server

namespace detail {

AudioUnimplementedDriver AudioRecordSession::s_StubDriver[server::FinalOutputRecorderManagerImpl::NumberOfFinalOutputRecorderSessions];

AudioRecordSession::AudioRecordSession(int32_t sessionId, nn::os::SystemEvent& releaseClientBufferEvent) NN_NOEXCEPT
    : AudioSession(sessionId, GetDriver(sessionId), releaseClientBufferEvent, server::SessionType_Output)
{
    NN_UNUSED(sessionId);
    NN_UNUSED(releaseClientBufferEvent);
}

AudioRecordSession::~AudioRecordSession() NN_NOEXCEPT
{
}

const char* AudioRecordSession::GetDefaultName() const NN_NOEXCEPT
{
    return "";
}

Result AudioRecordSession::IsSupported(const char* name, const server::SessionFormat& format) const NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(format);
    NN_RESULT_THROW(ResultNotImplemented());
}

FinalOutputRecorderState AudioRecordSession::GetState() const NN_NOEXCEPT
{
    switch(m_State)
    {
        case server::SessionState_Started:
            return FinalOutputRecorderState_Stopped;
        case server::SessionState_Stopped:
            return FinalOutputRecorderState_Stopped;
        default:
            NN_UNEXPECTED_DEFAULT;
    }
}

AudioDriver* AudioRecordSession::GetDriver(int sessionId) const NN_NOEXCEPT
{
    NN_ABORT_UNLESS_MINMAX(sessionId, 0, static_cast<int>(NN_ARRAY_SIZE(s_StubDriver)) - 1);
    return &s_StubDriver[sessionId];
}

void AudioRecordSession::SetAudioOutVolume(float volume) NN_NOEXCEPT
{
    s_StubDriver[m_SessionId].SetDeviceGain(volume);
}

float AudioRecordSession::GetAudioOutVolume() const NN_NOEXCEPT
{
    return s_StubDriver[m_SessionId].GetDeviceGain();
}

}}} // namespace nn::audio::detail
