﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/audio/audio_EffectTypes.h>
#include "../dsp/audio_Upsampler.h"
#include "../common/audio_Util.h"

namespace nn { namespace audio { namespace server {

class UpsamplerManager
{
private:
    int32_t m_Count;
    UpsamplerInfo* m_Infos;
    int8_t* pOutBuffers;
    nn::os::Mutex m_Mutex;
#if 0
    int8_t _padding[16];  // -Wunused-private-field
#else
    NN_PADDING8;
    NN_PADDING8;
#endif

public:
    UpsamplerManager(int count, UpsamplerInfo* pInfo, int8_t* pBuffers) NN_NOEXCEPT;
    UpsamplerInfo* Allocate() NN_NOEXCEPT;
    void Free(UpsamplerInfo* p) NN_NOEXCEPT;
};
#if defined(NN_BUILD_CONFIG_SPEC_NX) && !defined(NN_BUILD_CONFIG_OS_WIN)
NN_AUDIO_INFOTYPE_CHECK(UpsamplerManager, NN_AUDIO_ADDRESS_SELECT(48, 72));
#endif


}}}  // namespace nn::audio::server
