﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nne/audio/audio.h>

namespace nn { namespace audio { namespace dsp {

class MailBoxImplByAdspMailBoxCpu
{
protected:
    nne::audio::adsp::MboxType m_AdspMailBox;
    nn::os::SemaphoreType      m_MailBoxSemaphore;
public:
    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;
    void Open(int id, bool isServer) NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    void Send(int32_t message) NN_NOEXCEPT;
    int32_t Recv() NN_NOEXCEPT;
};

typedef MailBoxImplByAdspMailBoxCpu MailBoxImpl;

}}}  // namespace nn::audio::dsp

