﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/dd/dd_Types.h>
#include <nn/os/os_Tick.h>
#include <nn/result/result_HandlingUtility.h>
#include "audio_Dsp.h"

namespace nn { namespace audio { namespace dsp {

Result Start() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void Stop() NN_NOEXCEPT
{

}

void WaitForUnmap() NN_NOEXCEPT
{

}

void UnmapUserPointer(CpuAddr buffer, size_t size) NN_NOEXCEPT
{
    UnmapUserPointer(nn::os::InvalidNativeHandle, buffer, size);
}

void UnmapUserPointer(nn::dd::ProcessHandle processHandle, CpuAddr buffer, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(processHandle);
    NN_UNUSED(buffer);
    NN_UNUSED(size);
}

void ProcessCleanup(nn::dd::ProcessHandle processHandle) NN_NOEXCEPT
{
    NN_UNUSED(processHandle);
}

DspAddr MapUserPointer(nn::dd::ProcessHandle processHandle, CpuAddr buffer, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(size);
    NN_UNUSED(processHandle);

    // When using the CPU AudioRenderer, this is a no-op.
    return static_cast<DspAddr>(buffer.GetAddress());
}

DspAddr MapUserPointer(CpuAddr buffer, size_t size) NN_NOEXCEPT
{
    return MapUserPointer(nn::os::InvalidNativeHandle, buffer, size);
}

void InvalidateDspCache(DspAddr address, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(address);
    NN_UNUSED(size);
}

void SendCommandBuffer(int sessionId, DspAddr command, size_t size, int renderingTimeLimitPercent, bool isNew, uint64_t clientId)  NN_NOEXCEPT
{
    NN_UNUSED(renderingTimeLimitPercent);
    NN_UNUSED(isNew);
    NN_UNUSED(clientId);
}

void Wait() NN_NOEXCEPT
{

}

int GetRemainCommandCount(int sessionId) NN_NOEXCEPT
{
    NN_UNUSED(sessionId);

    return 0;
}

void ClearRemainCommandCount(int sessionId) NN_NOEXCEPT
{
    NN_UNUSED(sessionId);
}

int64_t GetRenderingStartTick(int sessionId) NN_NOEXCEPT
{
    NN_UNUSED(sessionId);
    return nn::os::GetSystemTick().GetInt64Value();
}


void Signal() NN_NOEXCEPT
{

}

void SessionSuspend(AppletVolumeManager::SessionType type, int index) NN_NOEXCEPT
{
    NN_UNUSED(type);
    NN_UNUSED(index);
}

void SessionResume(AppletVolumeManager::SessionType type, int index) NN_NOEXCEPT
{
    NN_UNUSED(type);
    NN_UNUSED(index);
}

void SetVolume(AppletVolumeManager::SessionType type, int index, float volume, uint32_t durationUsec) NN_NOEXCEPT
{
    NN_UNUSED(type);
    NN_UNUSED(index);
    NN_UNUSED(volume);
    NN_UNUSED(durationUsec);
}

void Wake() NN_NOEXCEPT
{
}

void Sleep() NN_NOEXCEPT
{
}

void DumpMappedPointer() NN_NOEXCEPT
{

}
} // namespace dsp

}}// namespace nn::audio

