﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../common/audio_CommonWaveBuffer.h"

namespace nn {
namespace audio {

int DecodePcm16(int32_t* output, const common::WaveBuffer* pWaveBuffer, int32_t channel, int32_t channelCount, int32_t offset, int sampleCount);
int DecodeAdpcm(int32_t* output, const common::WaveBuffer* pWaveBuffer, int32_t offset, int sampleCount, const int16_t* pCoef, void* pContext) NN_NOEXCEPT;

}  // namespace audio
}  // namespace nn
