﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_BitPack.h>

namespace nn { namespace audio {

struct VoiceBehaviorFlag final
{
    typedef ::nn::util::BitPack<uint16_t, VoiceBehaviorFlag>::Field<0, 1, bool> IsPlayedSampleCountResetAtLoopPoint;
    typedef ::nn::util::BitPack<uint16_t, VoiceBehaviorFlag>::Field<1, 1, bool> IsPitchAndSrcSkipped;
};

using VoiceBehaviorFlagSet = nn::util::BitPack<uint16_t, VoiceBehaviorFlag>;

}}  // namespace nn::audio
