﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_SplitterParameters.h"

namespace nn { namespace audio { namespace common {

namespace {

const char* SplitterInParamHeaderMagic = "SNDH";
const char* SplitterInfoMagic = "SNDI";
const char* SplitterSendDataMagic = "SNDD";

}

uint32_t GetSplitterInParamHeaderMagic() NN_NOEXCEPT
{
    return CreateMagic(SplitterInParamHeaderMagic);
}
uint32_t GetSplitterInfoMagic() NN_NOEXCEPT
{
    return CreateMagic(SplitterInfoMagic);
}
uint32_t GetSplitterSendDataMagic() NN_NOEXCEPT
{
    return CreateMagic(SplitterSendDataMagic);
}

}}}  // namespace nn::audio::common
