﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Macro.h>
#include <nn/nn_StaticAssert.h>
#include <nn/audio/audio_SampleFormat.h>
#include "audio_Util.h"

namespace nn { namespace audio { namespace common {

enum SinkType : int8_t
{
    SinkType_Invalid = 0,
    SinkType_Device,
    SinkType_CircularBuffer,
};

static const int InputCountMax = 6;
static const int InternlInputCountMax = 6;
static const int SinkNameMaxLength = 255;
typedef char DeviceIdentifier[SinkNameMaxLength];

struct CircularBufferParameter
{
    uint64_t _bufferAddress;
    int32_t _size;
    int32_t _inputCount;
    int32_t _sampleCount;
    int32_t _previousPosition;
    SampleFormat _sampleFormat;
    int8_t _input[InputCountMax];
    bool _isInUse;
    int8_t _padding[5];
};
NN_STATIC_ASSERT(sizeof(CircularBufferParameter) == 40);

struct CircularBufferStatus
{
    int32_t _currentPosition;
    int8_t _padding[4];
    uint64_t _glitchSize;
};
NN_STATIC_ASSERT(sizeof(CircularBufferStatus) == 16);

struct DeviceParameter
{
    static const int CoeffCount = 4;

    DeviceIdentifier id;
    int8_t _padding0[1];
    int32_t inputCount;
    int8_t input[InputCountMax];
    int8_t _padding1[1];
    bool useDownMixMatrix;
    float downMixMatrixCoeff[CoeffCount];
};
NN_STATIC_ASSERT(sizeof(DeviceParameter) == 284);


struct NN_AUDIO_INFOTYPE_FILED_ALIGN SinkInParameter
{
    SinkType _type;
    bool _isInUse;
    int8_t _padding0[2];
    NodeId _nodeId;
    int8_t _padding1[20];
    union
    {
        common::CircularBufferParameter _circular;
        common::DeviceParameter _device;
    };
};
NN_AUDIO_INFOTYPE_CHECK(SinkInParameter, 320);

struct NN_AUDIO_INFOTYPE_FILED_ALIGN SinkOutStatus
{
    union
    {
        common::CircularBufferStatus circular;
    };
    int8_t _padding[16];
};
NN_AUDIO_INFOTYPE_CHECK(SinkOutStatus, 32);

}}}  // namespace nn::audio::common
