﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace audio { namespace common {

void DumpCommandStructSizeAndAligns() NN_NOEXCEPT;
void DumpCommand(const CommandListHeader* pCommandListHeader) NN_NOEXCEPT;
void DumpCommand(const CommandHeader pCommandHeader) NN_NOEXCEPT;
void DumpCommand(const PcmInt16DataSourceCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const AdpcmDataSourceCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const VolumeCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const VolumeRampCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const BiquadFilterCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const MixCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const MixRampCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const MixRampGroupedCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const DepopPrepareCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const DepopForMixBuffersCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const DelayCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const UpsampleCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const AuxCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const DeviceSinkCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const ReverbCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const CircularBufferSinkCommand* pCommand) NN_NOEXCEPT;
void DumpCommand(const PerformanceCommand* pCommand) NN_NOEXCEPT;
void DumpCommandList(const void* pCommandList, size_t commandListSize) NN_NOEXCEPT;

}}} // namespace nn::audio::common
