﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef>
#include <nn/nn_Common.h>
#include <nn/audio/audio_AudioRendererTypes.h>
#include <nn/audio/detail/audio_AudioRendererTypesInternal.h>

// AudioRendererParameterInternal 構造体のサイズ・アライン・変数の並び順のチェック
NN_STATIC_ASSERT(sizeof(::nn::audio::detail::AudioRendererParameterInternal) == 52);
NN_STATIC_ASSERT(NN_ALIGNOF(::nn::audio::detail::AudioRendererParameterInternal) == 4);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, sampleRate) == 0);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, sampleCount) == 4);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, mixBufferCount) == 8);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, subMixCount) == 12);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, voiceCount) == 16);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, sinkCount) == 20);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, effectCount) == 24);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, performanceFrameCount) == 28);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, isVoiceDropEnabled) == 32);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, _reserved1) == 33);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, splitterCount) == 36);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, splitterSendChannelCount) == 40);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, bufferSizeForAudioCodec) == 44);
NN_STATIC_ASSERT(offsetof(::nn::audio::detail::AudioRendererParameterInternal, _magic) == 48);
