﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/audio/audio_SampleFormat.h>

namespace nn {
namespace audio {

size_t GetSampleByteSize(SampleFormat sampleFormat) NN_NOEXCEPT
{
    switch (sampleFormat)
    {
        case SampleFormat_PcmInt8:
            return 1;
        case SampleFormat_PcmInt16:
            return 2;
        case SampleFormat_PcmInt24:
            return 3;
        case SampleFormat_PcmInt32:
            NN_FALL_THROUGH;
        case SampleFormat_PcmFloat:
            return 4;
        case SampleFormat_Invalid:
            NN_FALL_THROUGH;
        default:
            NN_UNEXPECTED_DEFAULT;
    }
}

}  // namespace audio
}  // namespace nn
