﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/applet/applet_Result.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Apis.h>

#include <nn/am/am_Shim.h>
#include <nn/am/am_Result.h>
#include <atomic>

namespace nn { namespace applet {

//-----------------------------------------------------------------------------
//  アプレットリソース ID の取得（一度取得した後はキャッシュ値を返す）
//
AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT
{
    return am::GetAppletResourceUserId();
}

//-----------------------------------------------------------------------------
//  呼出元アプレットの ARUID を返す
//
Result GetAppletResourceUserIdOfCallerApplet(AppletResourceUserId* pOutAruid) NN_NOEXCEPT
{
    AppletResourceUserId aruid = {};
    NN_UTIL_SCOPE_EXIT
    {
        *pOutAruid = aruid;
    };

    auto result = am::GetWindowController()->GetAppletResourceUserIdOfCallerApplet(&aruid);
    NN_RESULT_TRY(result)
        NN_RESULT_CATCH_CONVERT(am::ResultNoCallerApplet, applet::ResultNoCallerApplet());
        NN_RESULT_CATCH_CONVERT(am::ResultCallerAppletIsWinding, applet::ResultCallerAppletIsWinding());
        NN_RESULT_CATCH_ALL
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        }
    NN_RESULT_END_TRY

    NN_RESULT_SUCCESS;
}


//-----------------------------------------------------------------------------

}}  // namespace nn::applet

