﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include "apm_PerformanceServer.h"

namespace nn { namespace apm { namespace server {

void AddSessionToList(Session* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void RemoveSessionFromList(Session* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void UpdatePerformance() NN_NOEXCEPT
{
}

bool GetBatteryDrainingEnabled() NN_NOEXCEPT
{
    return false;
}

PerformanceConfiguration GetDefaultPerformanceConfiguration(PerformanceMode performanceMode) NN_NOEXCEPT
{
    NN_UNUSED(performanceMode);
    return PerformanceConfiguration_Invalid;
}

void GetThrottlingState(ThrottlingState* pOutThrottlingState) NN_NOEXCEPT
{
    NN_UNUSED(pOutThrottlingState);
}

void GetLastThrottlingState(ThrottlingState* pOutThrottlingState) NN_NOEXCEPT
{
    NN_UNUSED(pOutThrottlingState);
}

void ClearLastThrottlingState() NN_NOEXCEPT
{
}

void RequestPerformanceMode(PerformanceMode performanceMode) NN_NOEXCEPT
{
    NN_UNUSED(performanceMode);
}

PerformanceMode GetPerformanceMode() NN_NOEXCEPT
{
    return PerformanceMode_Invalid;
}

void GetEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT
{
    NN_UNUSED(pOutEventPtr);
    NN_UNUSED(target);
}

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

nn::os::SystemEventType* GetEventForUpdate(EventTarget eventTarget) NN_NOEXCEPT
{
    NN_UNUSED(eventTarget);
    return nullptr;
}

void Update() NN_NOEXCEPT
{
}

void HandleSocthermInterrupts() NN_NOEXCEPT
{
}

void SetBasePerformanceConfiguration(BasePerformanceConfiguration basePerformanceConfiguration) NN_NOEXCEPT
{
    NN_UNUSED(basePerformanceConfiguration);
}

void SetExternalAccessEnabled(bool enabled) NN_NOEXCEPT
{
    NN_UNUSED(enabled);
}

void LoadAndApplySettings() NN_NOEXCEPT
{
}

//! @}

}}} // namespace nn::apm::server
