﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.aoc
{
    [CppRefPath(@"<nn/aoc/aoc_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct AddOnContentIndex { }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId { }
}

namespace nn.aocsrv.detail
{
    public interface IAddOnContentManager : IServiceObject
    {
        [MethodId(0)]
        Result CountAddOnContentByApplicationId(Out<int> outCount, nn.ncm.ApplicationId targetApplication);

        [MethodId(1)]
        Result ListAddOnContentByApplicationId(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.aoc.AddOnContentIndex> outIndices, int offset, int count, nn.ncm.ApplicationId targetApplication);

        [MethodId(2)]
        Result CountAddOnContent(Out<int> outCount, [ProcessId] nn.Bit64 processId);

        [MethodId(3)]
        Result ListAddOnContent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.aoc.AddOnContentIndex> outIndices,  [ProcessId] nn.Bit64 processId, int offset, int count);

        [MethodId(4)]
        Result GetAddOnContentBaseIdByApplicationId(Out<nn.Bit64> outValue, nn.ncm.ApplicationId targetApplication);

        [MethodId(5)]
        Result GetAddOnContentBaseId(Out<nn.Bit64> outValue, [ProcessId] nn.Bit64 processId);

        [MethodId(6)]
        Result PrepareAddOnContentByApplicationId(nn.aoc.AddOnContentIndex targetIndex, nn.ncm.ApplicationId targetApplication);

        [MethodId(7)]
        Result PrepareAddOnContent(nn.aoc.AddOnContentIndex targetIndex, [ProcessId] nn.Bit64 processId);

        [MethodId(8)]
        Result GetAddOnContentListChangedEvent(Out<NativeHandle> outHandle);
    }
}
