﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/utility/am_StaticAllocatorCommon.h>
#include <cstdlib>

namespace nn { namespace am { namespace utility {

void* AllocateStaticDefault(std::size_t byteSize) NN_NOEXCEPT
{
    std::size_t mallocSize = (byteSize == 0) ? 1 : byteSize;
    return std::malloc(mallocSize);
}

void DeallocateStaticDefault(void* p, std::size_t) NN_NOEXCEPT
{
    std::free(p);
}

}}}
