﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.account
{
    [CppRefPath("<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid
    {
    }
}

namespace nn.settings
{
    [CppRefPath("<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 1)]
    public struct LanguageCode
    {
    }
}

namespace nn.oe
{
    [CppRefPath("<nn/oe/oe_ApplicationControlTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct DisplayVersion
    {
    }
}

namespace nn.pdm
{
    [CppRefPath("<nn/pdm/pdm_Types.h>")]
    [ExternalStruct(24, 8)]
    public struct ApplicationPlayStatistics
    {
    }
}

namespace nn.util
{
    [CppRefPath("<nn/util/util_UuidTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct Uuid
    {
    }
}

namespace nn.am.service
{
    [CppRefPath("<nn/am/service/am_CommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct ProgramSpecifyKind
    {
    }

    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IApplicationFunctions : IServiceObject
    {
        /// <summary>
        /// launchParameterKind に関する起動データを与える
        /// </summary>
        /// <param name="launchParameterKind"></param>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(1)]
        Result PopLaunchParameter(Out<IStorage> pOut, Bit32 launchParameterKind);

        /// <summary>
        /// applicationId のアプリケーションを作成し、pStorage を LaunchParameterKind_Application で push し、SA に開始リクエストを送る
        /// </summary>
        /// <param name="applicationId">invalid な場合は、自身の ApplicationId を指定したこととする</param>
        /// <param name="pStorage"></param>
        /// <returns></returns>
        [MethodId(10)]
        Result CreateApplicationAndPushAndRequestToStart(ncm.ApplicationId applicationId, IStorage pStorage);

        /// <summary>
        /// 拡張属性付きで CreateApplicationAndPushAndRequestToStart() 相当の処理を行なう
        /// </summary>
        /// <param name="applicationId">invalid な場合は、自身の ApplicationId を指定したこととする</param>
        /// <param name="pStorage">ストレージ</param>
        /// <param name="pAttribute">拡張属性</param>
        /// <returns></returns>
        /// <remarks>
        /// 試遊台向けの拡張属性付きアプリ起動
        /// </remarks>
        [MethodId(11)]
        Result CreateApplicationAndPushAndRequestToStartForQuest(ncm.ApplicationId applicationId, IStorage pStorage, uint32_t playableTime, uint32_t idleDetectionTime);

        /// <summary>
        /// applicationId のアプリケーションを作成し、SA に開始リクエストを送る
        /// </summary>
        /// <param name="applicationId">invalid な場合は、自身の ApplicationId を指定したこととする</param>
        /// <returns></returns>
        /// <remarks>
        /// CreateApplicationAndPushAndRequestToStart() のストレージなし版です
        /// </remarks>
        [MethodId(12)]
        Result CreateApplicationAndRequestToStart(ncm.ApplicationId applicationId);

        /// <summary>
        /// 拡張属性付きで CreateApplicationAndRequestToStart() 相当の処理を行なう
        /// </summary>
        /// <param name="applicationId">invalid な場合は、自身の ApplicationId を指定したこととする</param>
        /// <param name="pAttribute">拡張属性</param>
        /// <returns></returns>
        /// <remarks>
        /// 試遊台向けの拡張属性付きアプリ起動
        /// CreateApplicationAndPushAndRequestToStartForQuest() のストレージなし版です
        /// </remarks>
        [MethodId(13)]
        Result CreateApplicationAndRequestToStartForQuest(ncm.ApplicationId applicationId, uint32_t playableTime, uint32_t idleDetectionTime);

        [MethodId(20)]
        Result EnsureSaveData(Out<int64_t> pOut, account.Uid uid);

        [MethodId(21)]
        Result GetDesiredLanguage(Out<nn.settings.LanguageCode> pOut);

        [MethodId(22)]
        Result SetTerminateResult(uint32_t result);

        [MethodId(23)]
        Result GetDisplayVersion(Out<nn.oe.DisplayVersion> outValue);

        [MethodId(24)]
        Result GetLaunchStorageInfoForDebug(Out<nn.ncm.StorageId> pOutLaunchStorage, Out<nn.ncm.StorageId> pOutPatchStorage);

        [MethodId(25)]
        Result ExtendSaveData(Out<int64_t> pOut, uint8_t saveDataType, account.Uid uid, int64_t saveDataSize, int64_t saveDataJournalSize);

        [MethodId(26)]
        Result GetSaveDataSize(Out<int64_t> pOutSize, Out<int64_t> pOutJournalSize, uint8_t saveDataType, account.Uid uid);

        [MethodId(27)]
        Result CreateCacheStorage(Out<int64_t> pOut, Out<int32_t> pOutTargetMedia, uint16_t index, int64_t cacheStorageSize, int64_t cacheStorageJournalSize);

        [MethodId(30)]
        Result BeginBlockingHomeButtonShortAndLongPressed(int64_t unused);

        [MethodId(31)]
        Result EndBlockingHomeButtonShortAndLongPressed();

        [MethodId(32)]
        Result BeginBlockingHomeButton(int64_t longPressTimeInNanoSeconds);

        [MethodId(33)]
        Result EndBlockingHomeButton();

        [MethodId(40)]
        Result NotifyRunning(Out<bool> pOut);

        [MethodId(50)]
        Result GetPseudoDeviceId(Out<nn.util.Uuid> pOutId);

        /// <summary>
        /// メディア再生中か否かを設定
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(60)]
        Result SetMediaPlaybackStateForApplication(bool isInMediaPlayback);

        /// <summary>
        /// ファームウェアが常時動画撮影をサポートしているか否かを返す
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(65)]
        Result IsGamePlayRecordingSupported(Out<bool> isSupported);

        /// <summary>
        /// 常時動画撮影用のワークメモリを渡す
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(66)]
        Result InitializeGamePlayRecording(NativeHandle transferMemoryHandle, uint64_t transferMemorySize);

        /// <summary>
        /// 常時動画撮影の録画制御
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(67)]
        Result SetGamePlayRecordingState(int state);

        /// <summary>
        /// 動画撮影中の動画ファイルの保存をシステムに要求
        /// </summary>
        /// <remarks>
        /// 内部的にはキャプチャボタン長押しをトリガする
        /// </remarks>
        [MethodId(68)]
        Result RequestFlushGamePlayingMovieForDebug();

        /// <summary>
        /// システムにシャットダウン開始を要求する
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(70)]
        Result RequestToShutdown();

        /// <summary>
        /// システムにリブート開始を要求する
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(71)]
        Result RequestToReboot();

        /// <summary>
        /// アプリを終了し、SA に Message_RequestToGoBackQuestMenu を通知する
        /// </summary>
        /// <remarks>
        /// 試遊台環境専用。それ以外では ResultNotQuestEnvironment を返す。
        /// </remarks>
        [MethodId(80)]
        Result ExitAndGoBackQuestMenu();

        /// <summary>
        /// アプリでの例外発生時にクラッシュレポートを収集するか否か設定する
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(90)]
        Result EnableApplicationCrashReport(bool isEnabled);

        /// <summary>
        /// Scoop 権利表記用フレームバッファをアプリから提供する
        /// </summary>
        /// <param name="handle">フレームバッファの TransferMemory ハンドル</param>
        /// <param name="size">フレームバッファのサイズ</param>
        /// <param name="width">フレームバッファの横幅ピクセル数</param>
        /// <param name="height">フレームバッファの縦幅ピクセル数</param>
        /// <remarks>
        /// </remarks>
        [MethodId(100)]
        Result InitializeApplicationCopyrightFrameBuffer(NativeHandle handle, uint64_t size, int width, int height);

        /// <summary>
        /// Scoop 権利表記用画像をフレームバッファに書き込む
        /// </summary>
        /// <param name="buffer">転送元画像のバッファ情報</param>
        /// <param name="x">転送先の左上 X 座標</param>
        /// <param name="y">転送先の左上 Y 座標</param>
        /// <param name="width">転送元画像の横幅ピクセル数</param>
        /// <param name="height">転送元画像の縦幅ピクセル数</param>
        /// <param name="originMode">ウィンドウの OriginMode</param>
        /// <remarks>
        /// </remarks>
        [MethodId(101)]
        Result SetApplicationCopyrightImage([NonSecureMapTransfer] InBuffer buffer, int x, int y, int width, int height, int originMode);

        /// <summary>
        /// Scoop 権利表記用レイヤーを Scoop 保存時に合成するか否かを指定する
        /// </summary>
        /// <param name="isVisible">true なら合成する</param>
        /// <remarks>
        /// </remarks>
        [MethodId(102)]
        Result SetApplicationCopyrightVisibility(bool isVisible);

        [MethodId(110)]
        Result QueryApplicationPlayStatistics(Out<int> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.pdm.ApplicationPlayStatistics> outList,
            [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.ncm.ApplicationId> applicationIdList);

        [MethodId(120)]
        Result ExecuteProgram(ProgramSpecifyKind kind, Bit64 id);

        [MethodId(121)]
        Result ClearUserChannel();

        [MethodId(122)]
        Result UnpopToUserChannel(IStorage pStorage);

        [MethodId(123)]
        Result GetPreviousProgramIndex(Out<int32_t> pOut);

        [MethodId(124)]
        Result EnableApplicationAllThreadDumpOnCrash(bool isEnabled);

        #region デバッグ用

        [MethodId(500)]
        Result StartContinuousRecordingFlushForDebug(Out<NativeHandle> pOut, int64_t maxTimeInNanoSeconds);

        #endregion

        #region 暫定(正式追加はこれより前に追加すること)
        [MethodId(1000)]
        Result CreateMovieMaker(Out<IMovieMaker> pOut, NativeHandle transferMemoryHandle, uint64_t transferMemorySize);

        [MethodId(1001)]
        Result PrepareForJit();
        #endregion
    }

    [CppRefPath(Location.ProxiesSfdlPath)]
    public interface IApplicationProxy : IStackableAppletProxy
    {
        [MethodId(20)]
        Result GetApplicationFunctions(Out<IApplicationFunctions> pOut);
    }
}
