﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ncm
{
//    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
//    [ExternalStruct(8, 8)]
//    public struct ApplicationId
//    {
//    }

    [CppRefPath(@"<nn/ncm/ncm_SystemContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct SystemApplicationId
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct ApplicationLaunchRequestInfo
    {
    }
}

namespace nn.am.service
{
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IApplicationAccessor : IAppletAccessor
    {
        /// <summary>
        /// アプリケーションが再び FG となるように要求を出す
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// 現在 FG のアプレットに対して Message_ChangeIntoBackground を通知し、
        /// アプリケーションに対して Message_ChangeIntoForeground を通知します。
        /// このメソッドは SA が自発的に発行するため、上記 BG 遷移要求で
        /// SA が拒絶することは想定されておらず、上記シーケンスは必ず
        /// 成功しなければなりません。
        /// </remarks>
        [MethodId(101)]
        Result RequestForApplicationToGetForeground();

        /// <summary>
        /// アプリケーション起点の全ての LA を強制的に終了します。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(110)]
        Result TerminateAllLibraryApplets();

        /// <summary>
        /// アプリケーション起点の LA が残存しているか否かを返します。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(111)]
        Result AreAnyLibraryAppletsLeft(Out<bool> isLeft);

        [MethodId(112)]
        Result GetCurrentLibraryApplet(Out<IAppletAccessor> pOut);

        /// <summary>
        /// このアプリケーションの ApplicationId を取得する
        /// </summary>
        /// <param name="pOut"></param>
        /// <returns></returns>
        [MethodId(120)]
        Result GetApplicationId(Out<nn.ncm.ApplicationId> pOut);

        /// <summary>
        /// launchParameterKind に関する起動データを与える
        /// </summary>
        /// <param name="launchParameterKind"></param>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(121)]
        Result PushLaunchParameter(Bit32 launchParameterKind, IStorage storage);

        /// <summary>
        /// このアプリケーションの ApplicationControlProperty を取得する
        /// </summary>
        /// <param name="buffer"></param>
        /// <returns></returns>
        [MethodId(122)]
        Result GetApplicationControlProperty(OutBuffer buffer);

        /// <summary>
        /// このアプリケーションの ApplicationLaunchProperty を取得する
        /// </summary>
        /// <param name="buffer"></param>
        /// <returns></returns>
        [MethodId(123)]
        Result GetApplicationLaunchProperty(OutBuffer buffer);

        /// <summary>
        /// このアプリケーションの起動要求元情報を返す
        /// </summary>
        /// <param name="pOutInfo"></param>
        /// <returns></returns>
        [MethodId(124)]
        Result GetApplicationLaunchRequestInfo(Out<nn.applet.ApplicationLaunchRequestInfo> pOutInfo);

        [MethodId(130)]
        Result SetUsers(bool allUser, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<account.Uid> uids);

        [MethodId(131)]
        Result CheckRightsEnvironmentAvailable(Out<bool> pOut);

        [MethodId(132)]
        Result GetNsRightsEnvironmentHandle(Out<Bit64> pOut);
    }

    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IApplicationCreator : IServiceObject
    {
        /// <summary>
        /// アプリケーションを作成する。
        /// </summary>
        /// <param name="pOut"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        [MethodId(0)]
        Result CreateApplication(Out<IApplicationAccessor> pOut, nn.ncm.ApplicationId id);

        [MethodId(1)]
        Result PopLaunchRequestedApplication(Out<IApplicationAccessor> pOut);

        [MethodId(10)]
        Result CreateSystemApplication(Out<IApplicationAccessor> pOut, nn.ncm.SystemApplicationId id);

        [MethodId(100)]
        Result PopFloatingApplicationForDevelopment(Out<IApplicationAccessor> pOut);
    }
}
