﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.vi
{
    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectLayerHandleType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectProducerHandleType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectConsumerHandleType { }
}

namespace nn.vi.fbshare
{

    [CppRefPath("<nn/vi/fbshare/vi_SharedBufferHandle.h>")]
    [ExternalStruct(8, 8)]
    public struct SharedBufferHandle { }

    [CppRefPath("<nn/vi/fbshare/vi_SharedLayerHandle.h>")]
    [ExternalStruct(8, 8)]
    public struct SharedLayerHandle { }
}

namespace nn.am.service
{
    [CppRefPath(Location.CommonTypesPath)]
    public struct IntegratedAppletPointer
    {
    }

    /// <summary>
    /// アプレットプロキシの共通インターフェイス
    /// </summary>
    [CppRefPath(Location.ProxiesSfdlPath)]
    public interface IAppletProxyCommon : IServiceObject
    {
        [MethodId(0)]
        Result GetCommonStateGetter(Out<ICommonStateGetter> pOut);

        [MethodId(1)]
        Result GetSelfController(Out<ISelfController> pOut);

        [MethodId(2)]
        Result GetWindowController(Out<IWindowController> pOut);

        [MethodId(3)]
        Result GetAudioController(Out<IAudioController> pOut);

        [MethodId(4)]
        Result GetDisplayController(Out<IDisplayController> pOut);

        [MethodId(1000)]
        Result GetDebugFunctions(Out<IDebugFunctions> pOut);
    }

    /// <summary>
    /// スタック可能なアプレットのプロキシ
    /// </summary>
    [CppRefPath(Location.ProxiesSfdlPath)]
    public interface IStackableAppletProxy : IAppletProxyCommon
    {
        [MethodId(10)]
        Result GetProcessWindingController(Out<IProcessWindingController> pOut);

        [MethodId(11)]
        Result GetLibraryAppletCreator(Out<ILibraryAppletCreator> pOut);
    }

    [CppRefPath(Location.CommonTypesPath)]
    public struct AppletIdentityInfo
    {
        public Bit32 appletId;
        public Bit32 reserved;
        public Bit64 applicationId;
    }

    /// <summary>
    /// アプレットへの直接のアクセッサ
    /// </summary>
    /// <remarks>
    /// 主に、起動した側からの操作として使用する。
    /// 機能は、
    /// - 状態取得
    /// - 終了リクエスト(必要？)
    /// - 強制終了(必要？)
    /// </remarks>
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IAppletAccessor : IServiceObject
    {
        [MethodId(-1)]
        [UseCmif(false)]
        Result GetIntegratedAppletPointer(Out<IntegratedAppletPointer> pOut);

        /// <summary>
        /// アプレットの状態変化検知用のイベントを取得する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// IsCompleted などの返り値が変更された場合にシグナルされるイベントを取得する。
        /// </remarks>
        [MethodId(0)]
        Result GetAppletStateChangedEvent(Out<NativeHandle> pOut);

        /// <summary>
        /// アプレットが終了しているかどうかを取得する。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// 実行が終了していれば true を返す。
        /// </remarks>
        [MethodId(1)]
        Result IsCompleted(Out<bool> pState);

        /// <summary>
        /// アプレットを開始する
        /// </summary>
        /// <returns></returns>
        [MethodId(10)]
        Result Start();

        /// <summary>
        /// アプレットに終了要求を出す
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// アプレットに対して Message_Exit メッセージを通知します。
        /// </remarks>
        [MethodId(20)]
        Result RequestExit();

        /// <summary>
        /// 強制終了する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// 対象アプレットを強制的に終了します。
        /// </remarks>
        [MethodId(25)]
        Result Terminate();

        [MethodId(30)]
        Result GetResult();
    }

    [CppRefPath(Location.FoundationSfdlPath)]
    public interface ILockAccessor : IServiceObject
    {
        [MethodId(1)]
        Result TryLock(Out<bool> pOut, Out<NativeHandle> pOutEventHandle, bool needsEvent);

        [MethodId(2)]
        Result Unlock();

        [MethodId(3)]
        Result GetEvent(Out<NativeHandle> pOutEventHandle);
    }
}
