﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/service/am_AppletSystem.h>

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  SpsmEvent 監視用クラス
//
class SpsmEvent
{
public:
    explicit SpsmEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT;
    ~SpsmEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_EventHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_EventHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_EventHolder)
        {
            ProcessSpsmEvent();
            return true;
        }
        return false;
    }

private:
    void ProcessSpsmEvent() NN_NOEXCEPT;

    void NotifyShortPressingPowerButton() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "power button short pressed\n");
        m_pAppletSystem->GetWindowManager()->NotifyPowerButtonShortPressed();
    }

    void NotifyMiddlePressingPowerButton() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "power button middle pressed\n");
        m_pAppletSystem->GetWindowManager()->NotifyPowerButtonMiddlePressed();
    }

    void NotifyLongPressingPowerButton() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "power button long pressed\n");
        m_pAppletSystem->GetWindowManager()->NotifyPowerButtonLongPressed();
    }

    void NotifySleepRequiredByHighTemperature() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "sleep required by high temperature\n");
        m_pAppletSystem->GetWindowManager()->NotifySleepRequiredByHighTemperature();
    }

    void NotifySleepRequiredByLowBattery() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "sleep required by low battery\n");
        m_pAppletSystem->GetWindowManager()->NotifySleepRequiredByLowBattery();
    }

    void NotifyAutoPowerDown() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "auto power down requested\n");
        m_pAppletSystem->GetWindowManager()->NotifyAutoPowerDown();
    }

    void NotifyReceivingCecSystemStandby() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "cec system standby received\n");
        m_pAppletSystem->GetWindowManager()->NotifyCecSystemStandbyReceived();
    }

    void NotifyShortPressingHomeButton() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "home button short pressed\n");
        m_pAppletSystem->GetWindowManager()->NotifyHomeButtonShortPressed();
    }

    void NotifyLongPressingHomeButton() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "home button long pressed\n");
        m_pAppletSystem->GetWindowManager()->NotifyHomeButtonLongPressed();
    }

private:
    AppletSystem* m_pAppletSystem;

    os::SystemEventType     m_Event;
    os::MultiWaitHolderType m_EventHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

