﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/service/am_AppletSystem.h>

namespace nn { namespace am { namespace service {

class FatalEvent
{
public:

    explicit FatalEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT;
    ~FatalEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_Holder);
    }

    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_Holder);
    }

    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_Holder)
        {
            FatalEventHandler();
            return true;
        }
        return false;
    }

private:

    void FatalEventHandler() NN_NOEXCEPT;

private:

    AppletSystem* m_pAppletSystem;
    os::SystemEvent m_Event;
    os::MultiWaitHolderType m_Holder;

};

}}}
