﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_AccountWrapper.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/am/service/am_ServiceDiagnostics.h>
#include <nn/am/service/am_StuckChecker.h>
#include <nn/account/account_Api.h>

#include <mutex>
#include <cstring>

namespace nn { namespace am { namespace service {

Result GetOpenUserIdList(capsrv::UserIdList* pOutList) NN_NOEXCEPT
{
    std::memset(pOutList, 0, sizeof(*pOutList));

    const int countMax = sizeof(pOutList->uid) / sizeof(pOutList->uid[0]);
    int count = 0;
    auto result = NN_AM_SERVICE_STUCK_CHECKED(account_ListOpenUsers, 30, account::ListOpenUsers(&count, pOutList->uid, countMax));
    NN_AM_SERVICE_LOG(seq, "GetOpenUserIdList() count=%d result=0x%08x\n", count, result.GetInnerValueForDebug());
    NN_RESULT_DO(result);
    for (int i=0; i<count; ++i)
    {
        NN_AM_SERVICE_LOG(seq, "  account[%d]={ 0x%016llx, 0x%016llx }\n", i, pOutList->uid[i]._data[0], pOutList->uid[i]._data[1]);
    }
    pOutList->uidCount = static_cast<uint8_t>(count);
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::am::service
