﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ahid_Hdr.h"

namespace nn {
namespace ahid {
namespace hdr {

//////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::Initialize() NN_NOEXCEPT
{
    memset(m_ServerDeviceParameters, 0, sizeof(ServerDeviceParameters) * HdrDeviceCountMax);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::Finalize() NN_NOEXCEPT
{
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::Attach(int index, DeviceParameters* pDeviceParameters) NN_NOEXCEPT
{
    if (index < HdrDeviceCountMax)
    {
        memcpy(&m_ServerDeviceParameters[index], pDeviceParameters, sizeof(DeviceParameters));

        // record attach time for attach filter
        m_ServerDeviceParameters[index].attachTime = nn::os::GetSystemTick().GetInt64Value();

        return ResultSuccess();
    }

    return ResultMaxEntries();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::Detach(int index) NN_NOEXCEPT
{
    if (index < HdrDeviceCountMax)
    {
        memset(&m_ServerDeviceParameters[index], 0, sizeof(ServerDeviceParameters));

        return ResultSuccess();
    }

    return ResultMaxEntries();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::GetDeviceParameters(int index, DeviceParameters* pDeviceParameters) NN_NOEXCEPT
{
    if (index < HdrDeviceCountMax)
    {
        memcpy(
            pDeviceParameters,
            &m_ServerDeviceParameters[index],
            sizeof(DeviceParameters)
            );

        return ResultSuccess();
    }

    return ResultMaxEntries();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrDevice::GetServerDeviceParameters(int index, ServerDeviceParameters* pServerDeviceParameters) NN_NOEXCEPT
{
    if (index < HdrDeviceCountMax)
    {
        memcpy(pServerDeviceParameters, &m_ServerDeviceParameters[index], sizeof(ServerDeviceParameters));

        return ResultSuccess();
    }

    return ResultMaxEntries();
}


//////////////////////////////////////////////////////////////////////////////
//  private functions
//////////////////////////////////////////////////////////////////////////////


}   // namespace hdr
}   // namespace ahid
}   // namespace nn
