﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>
#include <nn/am/service/am_CommonTypes.h>

#include <nn/applet/applet_Types.h>

#include <nn/ae/ae_DebugApi.h>
#include <nn/ae/ae_Result.h>
#include <nn/ae/ae_Types.h>
#include <nn/ae/ae_SystemAppletControlForDebug.h>

namespace nn { namespace ae {

namespace {

void EmulateButtonEvent(am::service::EmulatedButtonEvent e) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetDebugFunctions()->EmulateButtonEvent(e));
}

}   // namespace anonymous

//-----------------------------------------------------------------------------
//  HOME ボタン押下（短／長押し）のメッセージを配信（デバッグ用）
//
void NotifyShortPressingHomeButtonForDebug() NN_NOEXCEPT
{
    EmulateButtonEvent(am::service::EmulatedButtonEvent_PressHomeButtonShort);
}

void NotifyLongPressingHomeButtonForDebug() NN_NOEXCEPT
{
    EmulateButtonEvent(am::service::EmulatedButtonEvent_PressHomeButtonLong);
}


//-----------------------------------------------------------------------------
//  POWER ボタン押下（短／中／長押し）のメッセージを配信（デバッグ用）
//
void NotifyShortPressingPowerButtonForDebug() NN_NOEXCEPT
{
    EmulateButtonEvent(am::service::EmulatedButtonEvent_PressPowerButtonShort);
}

void NotifyMiddlePressingPowerButtonForDebug() NN_NOEXCEPT
{
    EmulateButtonEvent(am::service::EmulatedButtonEvent_PressPowerButtonMiddle);
}

void NotifyLongPressingPowerButtonForDebug() NN_NOEXCEPT
{
    EmulateButtonEvent(am::service::EmulatedButtonEvent_PressPowerButtonLong);
}

//-----------------------------------------------------------------------------

void InvalidateTransitionLayerForDevelop() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetDebugFunctions()->InvalidateTransitionLayer());
}

//-----------------------------------------------------------------------------

void RequestLaunchApplicationToSystemAppletForDebug(ncm::ApplicationId applicationId, util::Span<const account::Uid> uids) NN_NOEXCEPT
{
    auto p = am::CreateSystemAppletControllerForDebug();
    NN_ABORT_UNLESS_RESULT_SUCCESS(p->RequestLaunchApplicationForDebug(applicationId, uids));
}

}}  // namespace nn::ae

