﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_NasAuthorizationHeader.h"

#include "../detail/account_CacheUtil.h"
#include <nn/account/account_Result.h>

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account { namespace nas {

Result CreateAuthorizationHeader(char* buffer, size_t bufferSize, const detail::Uuid& accessTokenCacheId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(buffer != nullptr);
    NN_SDK_REQUIRES(bufferSize >= RequiredBufferSizeForAuthorizationHeader);

    // Authorization ヘッダの準備
    auto offset = sizeof(AuthorizationLead) - 1;
    NN_SDK_ASSERT(bufferSize > offset);
    std::memcpy(buffer, AuthorizationLead, offset);

    // アクセストークンの取得
    size_t accessTokenSizeActual;
    NN_RESULT_DO((detail::CacheUtil::LoadCacheFile<detail::NasAccessTokenSizeMax, ResultNasTokenLengthUnacceptable>(
        &accessTokenSizeActual, buffer + offset, bufferSize - offset,
        accessTokenCacheId, storage)));
    offset += accessTokenSizeActual;
    NN_SDK_ASSERT(bufferSize > offset);

    NN_RESULT_THROW_UNLESS(offset + 1 <= bufferSize, ResultInsufficientBuffer());
    buffer[offset] = '\0';
    NN_SDK_ASSERT(strnlen(buffer, bufferSize) == offset);
    NN_RESULT_SUCCESS;
}

}}}

