﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cctype>

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace account { namespace http {

// src を URL エンコードし dst に格納する
// pre: src は '\0' で終端されている
// post: dst は '\0' で終端される
int UrlEncode(char *dst, size_t dstSize, const char* src, size_t srcSize) NN_NOEXCEPT;

// codedTest が expect を URL エンコードしたものと部分(終端以外)一致する
// pre: expect は '\0' で終端されている
bool CompareEncodedStringPartially(const char* expect, size_t expectSize, const char* codedTest, size_t codedTestSize) NN_NOEXCEPT;

// URI
bool IsReservedCharacterForUri(char c) NN_NOEXCEPT;
bool IsUnreservedCharacterForUri(char c) NN_NOEXCEPT;
size_t PutCharacterWithUrlEncoding(char* str, size_t strSize, char c) NN_NOEXCEPT;

}}} // ~namespace nn::account::http
