﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/http/account_CurlInputStream.h>

#include "account_HttpUtil.h"

namespace nn { namespace account { namespace http {
CurlInputStream::CurlInputStream(CURL* curlHandle, const util::Cancelable* pCancellable) NN_NOEXCEPT
    : nn::http::stream::CurlInputStream(curlHandle, pCancellable)
{
}

Result CurlInputStream::Initialize() NN_NOEXCEPT
{
    NN_RESULT_DO(nn::http::stream::CurlInputStream::Initialize());
    NN_RESULT_DO(nn::http::stream::CurlInputStream::SetUserAgent(GetUserAgent()));
    NN_RESULT_DO(nn::http::stream::CurlInputStream::SetErrorHandler(DefaultErrorHandler));
    NN_RESULT_SUCCESS;
}
}}} // ~namespace http
