﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/baas/account_NetworkServiceAccountFloatingRegistrationImpl.h>
#include <nn/account/profile/account_ProfileStorage.h>
#include <nn/account/user/account_UserRegistry.h>

#include "../profile/account_ProfileAdaptor.h"

namespace nn { namespace account { namespace baas {

Result UserRegistrar::CompleteRegistrationImpl(const Uid& uid, const UserProfile& profile, const void* image, size_t imageSize) NN_NOEXCEPT
{
    // 失敗時は登録キャンセル
    bool cancelRequired = true;
    NN_UTIL_SCOPE_EXIT
    {
        if (cancelRequired)
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(m_Registry.CancelUserRegistration(uid));
        }
    };

    //
    profile::ProfileAdaptor adaptor(&m_ProfileStorage, uid, true /* forceImport */);

    // サーバー側のデータの検証
    profile::ProfileBase base;
    profile::UserData userData;
    NN_RESULT_DO(adaptor.Decode(&base, &userData, profile.base));

    // プロフィール登録 & ユーザー登録完了
    m_ProfileStorage.Add(uid);
    NN_RESULT_DO(adaptor.Import(base, userData, image, imageSize));
    NN_RESULT_DO(m_Registry.CompleteUserRegistration(uid));
    cancelRequired = false;
    NN_RESULT_SUCCESS;
}

Result UserRegistrar::Create(Uid* pOut, const UserProfile& profile, const void* image, size_t imageSize) NN_NOEXCEPT
{
    auto& storage = m_ProfileStorage.GetStorageRef();
    auto lock = storage.AcquireWriterLock();
    Uid uid;
    NN_RESULT_DO(m_Registry.BeginUserRegistration(&uid));
    NN_RESULT_DO(CompleteRegistrationImpl(uid, profile, image, imageSize));
    NN_RESULT_DO(storage.Commit());
    *pOut = uid;
    NN_RESULT_SUCCESS;
}

Result UserRegistrar::Import(const Uid& uid, const UserProfile& profile, const void* image, size_t imageSize) NN_NOEXCEPT
{
    auto& storage = m_ProfileStorage.GetStorageRef();
    auto lock = storage.AcquireWriterLock();
    NN_RESULT_DO(m_Registry.BeginUserRegistrationAs(uid));
    NN_RESULT_DO(CompleteRegistrationImpl(uid, profile, image, imageSize));
    NN_RESULT_DO(storage.Commit());
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::account::baas
