﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/baas/account_BaasUserResourceCache.h>

#include <nn/os/os_Tick.h>

namespace nn {
namespace account {
namespace baas {

void BaasUserResourceCache::Store(const Uid& tag, const Uid& author, uint64_t lasModified) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(author);

    BaasUserResource resource;
    resource.timeStamp = os::GetSystemTick().ToTimeSpan();
    resource.author = author;
    resource.lastModified = lasModified;
    Base::Store(tag, 0, resource);
}
Result BaasUserResourceCache::Get(BaasUserResource* pOut, const Uid& tag) const NN_NOEXCEPT
{
    std::lock_guard<const Base> lock(*static_cast<const Base*>(this));
    return Base::FindUnsafe(pOut, tag);
}

} // ~namespace nn::account::baas
}
}
