﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * ローカルとリモート計測共通の動作設定
 */

#include <nn/os.h>
#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

#include <nnd/tmp451/tmp451.h>

namespace nnd {
namespace tmp451 {
namespace detail {

nn::Result GetMeasurementRange(MeasurementRange* range, BusSessions bus) NN_NOEXCEPT;
nn::Result SetMeasurementRange(MeasurementRange range, BusSessions bus) NN_NOEXCEPT;
nn::Result GetMeasurementRateBy2ToThePowerN(int* n, BusSessions bus) NN_NOEXCEPT;
nn::Result SetMeasurementRateBy2ToThePowerN(int n, BusSessions bus) NN_NOEXCEPT;
nn::Result GetBusTimeoutFunctionEnabled(bool* enable, BusSessions bus) NN_NOEXCEPT;
nn::Result SetBusTimeoutFunctionEnabled(bool enable, BusSessions bus) NN_NOEXCEPT;

} // detail
} // tmp451
} // nnd
