﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * ドライバ内部で共通して使用するヘッダ(NX)
 */

#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

#include "tmp451_Specification.h"

namespace nnd {
namespace tmp451 {
namespace detail {

// バス関連のセッション群
struct BusSessions
{
    nn::gpio::GpioPadSession    gpioSessionInterruptPin2;
    nn::i2c::I2cSession         i2cSession;
};


} // detail
} // tmp451
} // nnd
