﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/driver/i2c_DriverService.h>

#include <nnd/i2c/skeleton/i2cSkeleton.h>

#include "detail/i2cSkeleton_DeviceCodeNodeParser.h"
#include "detail/i2cSkeleton_I2cBusAccessorManager.h"
#include "detail/i2cSkeleton_I2cDevicePropertyManager.h"
#include "detail/i2cSkeleton_TargetSpec.h"

namespace {

nnd::i2c::skeleton::detail::I2cBusAccessorManager<nnd::i2c::skeleton::detail::MaxBuses> g_I2cBusAccessorManager;
nnd::i2c::skeleton::detail::I2cDevicePropertyManager<nnd::i2c::skeleton::detail::MaxDevices> g_I2cDevicePropertyManager;

nnd::i2c::skeleton::detail::DeviceCodeBusParser g_DeviceCodeBusParser(
    g_I2cBusAccessorManager.GetAllocator());

nnd::i2c::skeleton::detail::DeviceCodeDeviceParser g_DeviceCodeDeviceParser(
    g_I2cBusAccessorManager.GetAllocator(),
    g_I2cDevicePropertyManager.GetAllocator());

}

namespace nnd { namespace i2c { namespace skeleton {

void Initialize() NN_NOEXCEPT
{
    nn::i2c::driver::RegisterDeviceCodeNodeParser(&g_DeviceCodeBusParser);
    nn::i2c::driver::RegisterDeviceCodeNodeParser(&g_DeviceCodeDeviceParser);
}

}}} // nnd::i2c::skeleton
