﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/mem.h>

#include <nn/gpio/driver/gpio_DriverService.h>

#include <nnd/gpio/tegra/gpioTegra.h>
#include <nnd/gpio/tegra/gpioTegra_InitialConfig.h>

#include "detail/gpioTegra_InitialConfig.h"
#include "detail/gpioTegra_PadManager.h"
#include "detail/gpioTegra_DeviceCodeNodeParser.h"
#include "detail/gpioTegra_DriverImpl.h"

namespace nnd { namespace gpio { namespace tegra {

namespace
{
    nnd::gpio::tegra::detail::PadManager<256> g_PadManager;
    nnd::gpio::tegra::detail::DriverImpl g_DriverImpl;
    nnd::gpio::tegra::detail::DeviceCodeNodeParserImpl g_DeviceCodeNodeParserImpl(g_DriverImpl, g_PadManager.GetAllocator());
}

void Initialize() NN_NOEXCEPT
{
    nn::gpio::driver::RegisterDriver(&g_DriverImpl);
    nn::gpio::driver::RegisterDeviceCodeNodeParser(&g_DeviceCodeNodeParserImpl);
}

void SetInitialGpioConfig() NN_NOEXCEPT
{
    detail::SetInitialGpioConfig();
}

void SetInitialWakePinConfig() NN_NOEXCEPT
{
    detail::SetInitialWakePinConfig();
}

}}} // nnd::gpio::tegra
