﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief   Identifiers for standard PCI class, vendor and
 *          devices (C language)
 */

enum nnpciePCIClassCodes
{
    nnpcieCLASS_NOT_DEFINED           = 0x0000,
    nnpcieCLASS_NOT_DEFINED_VGA       = 0x0001,
    nnpcieBASE_CLASS_STORAGE          = 0x01,
    nnpcieCLASS_STORAGE_SCSI          = 0x0100,
    nnpcieCLASS_STORAGE_IDE           = 0x0101,
    nnpcieCLASS_STORAGE_FLOPPY        = 0x0102,
    nnpcieCLASS_STORAGE_IPI           = 0x0103,
    nnpcieCLASS_STORAGE_RAID          = 0x0104,
    nnpcieCLASS_STORAGE_SATA          = 0x0106,
    nnpcieCLASS_STORAGE_SATA_AHCI     = 0x010601,
    nnpcieCLASS_STORAGE_SAS           = 0x0107,
    nnpcieCLASS_STORAGE_OTHER         = 0x0180,
    nnpcieBASE_CLASS_NETWORK          = 0x02,
    nnpcieCLASS_NETWORK_ETHERNET      = 0x0200,
    nnpcieCLASS_NETWORK_TOKEN_RING    = 0x0201,
    nnpcieCLASS_NETWORK_FDDI          = 0x0202,
    nnpcieCLASS_NETWORK_ATM           = 0x0203,
    nnpcieCLASS_NETWORK_OTHER         = 0x0280,
    nnpcieBASE_CLASS_DISPLAY          = 0x03,
    nnpcieCLASS_DISPLAY_VGA           = 0x0300,
    nnpcieCLASS_DISPLAY_XGA           = 0x0301,
    nnpcieCLASS_DISPLAY_3D            = 0x0302,
    nnpcieCLASS_DISPLAY_OTHER         = 0x0380,
    nnpcieBASE_CLASS_MULTIMEDIA       = 0x04,
    nnpcieCLASS_MULTIMEDIA_VIDEO      = 0x0400,
    nnpcieCLASS_MULTIMEDIA_AUDIO      = 0x0401,
    nnpcieCLASS_MULTIMEDIA_PHONE      = 0x0402,
    nnpcieCLASS_MULTIMEDIA_OTHER      = 0x0480,
    nnpcieBASE_CLASS_MEMORY           = 0x05,
    nnpcieCLASS_MEMORY_RAM            = 0x0500,
    nnpcieCLASS_MEMORY_FLASH          = 0x0501,
    nnpcieCLASS_MEMORY_OTHER          = 0x0580,
    nnpcieBASE_CLASS_BRIDGE           = 0x06,
    nnpcieCLASS_BRIDGE_HOST           = 0x0600,
    nnpcieCLASS_BRIDGE_ISA            = 0x0601,
    nnpcieCLASS_BRIDGE_EISA           = 0x0602,
    nnpcieCLASS_BRIDGE_MC             = 0x0603,
    nnpcieCLASS_BRIDGE_PCI            = 0x0604,
    nnpcieCLASS_BRIDGE_PCMCIA         = 0x0605,
    nnpcieCLASS_BRIDGE_NUBUS          = 0x0606,
    nnpcieCLASS_BRIDGE_CARDBUS        = 0x0607,
    nnpcieCLASS_BRIDGE_RACEWAY        = 0x0608,
    nnpcieCLASS_BRIDGE_OTHER          = 0x0680,
    nnpcieBASE_CLASS_COMMUNICATION    = 0x07,
    nnpcieCLASS_COMMUNICATION_SERIAL  = 0x0700,
    nnpcieCLASS_COMMUNICATION_PARALLEL = 0x0701,
    nnpcieCLASS_COMMUNICATION_MULTISERIAL = 0x0702,
    nnpcieCLASS_COMMUNICATION_MODEM   = 0x0703,
    nnpcieCLASS_COMMUNICATION_OTHER   = 0x0780,
    nnpcieBASE_CLASS_SYSTEM           = 0x08,
    nnpcieCLASS_SYSTEM_PIC            = 0x0800,
    nnpcieCLASS_SYSTEM_PIC_IOAPIC     = 0x080010,
    nnpcieCLASS_SYSTEM_PIC_IOXAPIC    = 0x080020,
    nnpcieCLASS_SYSTEM_DMA            = 0x0801,
    nnpcieCLASS_SYSTEM_TIMER          = 0x0802,
    nnpcieCLASS_SYSTEM_RTC            = 0x0803,
    nnpcieCLASS_SYSTEM_nnpcieHOTPLUG    = 0x0804,
    nnpcieCLASS_SYSTEM_SDHCI          = 0x0805,
    nnpcieCLASS_SYSTEM_OTHER          = 0x0880,
    nnpcieBASE_CLASS_INPUT            = 0x09,
    nnpcieCLASS_INPUT_KEYBOARD        = 0x0900,
    nnpcieCLASS_INPUT_PEN             = 0x0901,
    nnpcieCLASS_INPUT_MOUSE           = 0x0902,
    nnpcieCLASS_INPUT_SCANNER         = 0x0903,
    nnpcieCLASS_INPUT_GAMEPORT        = 0x0904,
    nnpcieCLASS_INPUT_OTHER           = 0x0980,
    nnpcieBASE_CLASS_DOCKING          = 0x0a,
    nnpcieCLASS_DOCKING_GENERIC       = 0x0a00,
    nnpcieCLASS_DOCKING_OTHER         = 0x0a80,
    nnpcieBASE_CLASS_PROCESSOR        = 0x0b,
    nnpcieCLASS_PROCESSOR_386         = 0x0b00,
    nnpcieCLASS_PROCESSOR_486         = 0x0b01,
    nnpcieCLASS_PROCESSOR_PENTIUM     = 0x0b02,
    nnpcieCLASS_PROCESSOR_ALPHA       = 0x0b10,
    nnpcieCLASS_PROCESSOR_POWERPC     = 0x0b20,
    nnpcieCLASS_PROCESSOR_MIPS        = 0x0b30,
    nnpcieCLASS_PROCESSOR_CO          = 0x0b40,
    nnpcieBASE_CLASS_SERIAL           = 0x0c,
    nnpcieCLASS_SERIAL_FIREWIRE       = 0x0c00,
    nnpcieCLASS_SERIAL_FIREWIRE_OHCI  = 0x0c0010,
    nnpcieCLASS_SERIAL_ACCESS         = 0x0c01,
    nnpcieCLASS_SERIAL_SSA            = 0x0c02,
    nnpcieCLASS_SERIAL_USB            = 0x0c03,
    nnpcieCLASS_SERIAL_USB_UHCI       = 0x0c0300,
    nnpcieCLASS_SERIAL_USB_OHCI       = 0x0c0310,
    nnpcieCLASS_SERIAL_USB_EHCI       = 0x0c0320,
    nnpcieCLASS_SERIAL_USB_XHCI       = 0x0c0330,
    nnpcieCLASS_SERIAL_FIBER          = 0x0c04,
    nnpcieCLASS_SERIAL_SMBUS          = 0x0c05,
    nnpcieBASE_CLASS_WIRELESS         = 0x0d,
    nnpcieCLASS_WIRELESS_RF_CONTROLLER = 0x0d10,
    nnpcieCLASS_WIRELESS_WHCI         = 0x0d1010,
    nnpcieBASE_CLASS_INTELLIGENT      = 0x0e,
    nnpcieCLASS_INTELLIGENT_I2O       = 0x0e00,
    nnpcieBASE_CLASS_SATELLITE        = 0x0f,
    nnpcieCLASS_SATELLITE_TV          = 0x0f00,
    nnpcieCLASS_SATELLITE_AUDIO       = 0x0f01,
    nnpcieCLASS_SATELLITE_VOICE       = 0x0f03,
    nnpcieCLASS_SATELLITE_DATA        = 0x0f04,
    nnpcieBASE_CLASS_CRYPT            = 0x10,
    nnpcieCLASS_CRYPT_NETWORK         = 0x1000,
    nnpcieCLASS_CRYPT_ENTERTAINMENT   = 0x1001,
    nnpcieCLASS_CRYPT_OTHER           = 0x1080,
    nnpcieBASE_CLASS_SIGNAL_PROCESSING = 0x11,
    nnpcieCLASS_SP_DPIO               = 0x1100,
    nnpcieCLASS_SP_OTHER              = 0x1180,
    nnpcieCLASS_OTHERS                = 0xff
};


enum nnpciePCIVendorAndDeviceIDs
{
    nnpcieVENDOR_ID_REALTEK                   = 0x10ec,
    nnpcieDEVICE_ID_REALTEK_8168              = 0x8168,

    // add more as needed

};




