﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @brief 認証設定を表す構造体です。
 */
typedef struct nnnifmAuthenticationSetting
{
    bool isEnabled;     //!< 認証を行うか否かを表すフラグ
    char username[32];  //!< ユーザー名
    char password[32];  //!< パスワード
} nnnifmAuthenticationSetting;

/**
 * @brief プロキシ情報を表す構造体です。
 */
typedef struct nnnifmProxySetting
{
    bool isEnabled;                               //!< プロキシを利用するか否かを表すフラグ
    uint16_t port;                                //!< ポート番号
    char proxy[100];                              //!< プロキシ名
    nnnifmAuthenticationSetting authentication;   //!< 認証設定
} nnnifmProxySetting;

