﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       デバイスの列挙などに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace xcd {

/**
 * @brief       Joy-Con と通信する Bluetooth のモードです。
 */
enum BluetoothSettings : uint8_t
{
    BluetoothSettings_Active = 0,      //!< 全てのコントローラーがアクティブ状態になります。
    BluetoothSettings_2x1Slot,         //!< ベーシック 2台
    BluetoothSettings_6x1Slot,         //!< ベーシック 6台
    BluetoothSettings_8x1Slot,         //!< ベーシック 8台
    BluetoothSettings_1xUp3Slot,       //!< Uplink 3Slot 1台
    BluetoothSettings_4xUp3Slot,       //!< Uplink 3Slot 4台
    BluetoothSettings_6xUp3Slot,       //!< Uplink 3slot 6台 (暫定)
    BluetoothSettings_4xUpDown3Slot,   //!< Uplink / Downlink 3slot 4台 (暫定)
};

/**
  * @brief       Joy-Con と通信する Bluetooth のモードを変更します。削除予定
  *
  * @details     Bluetooth のモード変更をします。
  *              Bluetooth の通信モードの変更には時間がかかります。
  *              変更が完了したときに、pSystemEvent で設定されたイベントに通知されます。
 *
 * @param[in]   bluetoothSettings                 設定する Bluetooth の通信モード
 *
 */
void SetBluetoothSettings(BluetoothSettings bluetoothSettings) NN_NOEXCEPT;

/**
 * @brief       現在の Bluetooth の通信モードを取得します。
 *
 * @return      現在の Bluetooth の通信モード
 */
BluetoothSettings GetBluetoothSettings() NN_NOEXCEPT;

}} // namespace nn::xcd
