﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       xcd (NX Controller Driver) に関する API の宣言
 */

#pragma once

/**
 * @namespace nn::xcd
 * @brief     xcd (NX Controller Driver) ドライライブラリの名前空間です。
 */

#include "xcd_Lib.h"
#include "xcd_AttachmentDevice.h"
#include "xcd_Ble.h"
#include "xcd_BleDevice.h"
#include "xcd_BleTypes.h"
#include "xcd_BluetoothConnection.h"
#include "xcd_BluetoothSettings.h"
#include "xcd_Device.h"
#include "xcd_DataFormat.h"
#include "xcd_DeviceState.h"
#include "xcd_Firmware.h"
#include "xcd_Input.h"
#include "xcd_Indicator.h"
#include "xcd_Result.h"
#include "xcd_Vibration.h"
#include "xcd_Pairing.h"
#include "xcd_SerialFlash.h"
#include "xcd_Tera.h"
#include "xcd_TeraFirmware.h"
#include "xcd_KuinaFirmware.h"
#include "xcd_NfcTypes.h"
#include "xcd_Nfc.h"
#include "xcd_Irsensor.h"
#include "xcd_Rail.h"
#include "xcd_Usb.h"

