﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/xcd/xcd_Device.h>
#include <nn/xcd/xcd_NfcTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace xcd { namespace detail { // NOLINT(whitespace/braces)

class ISystemServer;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDataFormat, (::nn::sf::Out<::std::uint8_t> pOutDataFormat, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDataFormat, (::std::uint8_t dataFormat, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuState, (::nn::sf::Out<::std::uint8_t> pOutMcuState, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuState, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuVersionForNfc, (::nn::sf::Out<::nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckNfcDevicePower, (::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuStateImmediate, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNfcEvent, (::nn::sf::Out<::nn::sf::NativeHandle> nfcEventHandle, ::nn::sf::Out<::nn::sf::NativeHandle> nfcDetectEventHandle, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNfcInfo, (::nn::sf::Out<::nn::xcd::NfcInfo> pOutValue, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartNfcDiscovery, (::nn::xcd::NfcDiscoveryParameter discoveryParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopNfcDiscovery, (::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagRead, (const ::nn::xcd::NtagReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagWrite, (const ::nn::xcd::NtagWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendNfcRawData, (const ::nn::xcd::NfcPassThruParameter& passThruParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterMifareKey, (const ::nn::xcd::MifareKeyWriteParameter& keyWriteParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearMifareKey, (::nn::xcd::MifareKeyClearParameter keyClearParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareRead, (const ::nn::xcd::MifareReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareWrite, (const ::nn::xcd::MifareWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForLeftRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForRightRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemServer)

        ::nn::Result GetDataFormat(::nn::sf::Out<::std::uint8_t> pOutDataFormat, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDataFormat, (pOutDataFormat, deviceHandle));
        }

        ::nn::Result SetDataFormat(::std::uint8_t dataFormat, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDataFormat, (dataFormat, deviceHandle));
        }

        ::nn::Result GetMcuState(::nn::sf::Out<::std::uint8_t> pOutMcuState, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMcuState, (pOutMcuState, deviceHandle));
        }

        ::nn::Result SetMcuState(::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMcuState, (mcuState, deviceHandle));
        }

        ::nn::Result GetMcuVersionForNfc(::nn::sf::Out<::nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMcuVersionForNfc, (pOutMcuVersionData, deviceHandle));
        }

        ::nn::Result CheckNfcDevicePower(::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckNfcDevicePower, (deviceHandle));
        }

        ::nn::Result SetMcuStateImmediate(::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMcuStateImmediate, (mcuState, deviceHandle));
        }

        ::nn::Result SetNfcEvent(::nn::sf::Out<::nn::sf::NativeHandle> nfcEventHandle, ::nn::sf::Out<::nn::sf::NativeHandle> nfcDetectEventHandle, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNfcEvent, (nfcEventHandle, nfcDetectEventHandle, deviceHandle));
        }

        ::nn::Result GetNfcInfo(::nn::sf::Out<::nn::xcd::NfcInfo> pOutValue, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNfcInfo, (pOutValue, deviceHandle));
        }

        ::nn::Result StartNfcDiscovery(::nn::xcd::NfcDiscoveryParameter discoveryParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartNfcDiscovery, (discoveryParameter, deviceHandle));
        }

        ::nn::Result StopNfcDiscovery(::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopNfcDiscovery, (deviceHandle));
        }

        ::nn::Result StartNtagRead(const ::nn::xcd::NtagReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartNtagRead, (readParameter, deviceHandle));
        }

        ::nn::Result StartNtagWrite(const ::nn::xcd::NtagWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartNtagWrite, (writeParameter, deviceHandle));
        }

        ::nn::Result SendNfcRawData(const ::nn::xcd::NfcPassThruParameter& passThruParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendNfcRawData, (passThruParameter, deviceHandle));
        }

        ::nn::Result RegisterMifareKey(const ::nn::xcd::MifareKeyWriteParameter& keyWriteParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterMifareKey, (keyWriteParameter, deviceHandle));
        }

        ::nn::Result ClearMifareKey(::nn::xcd::MifareKeyClearParameter keyClearParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearMifareKey, (keyClearParameter, deviceHandle));
        }

        ::nn::Result StartMifareRead(const ::nn::xcd::MifareReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartMifareRead, (readParameter, deviceHandle));
        }

        ::nn::Result StartMifareWrite(const ::nn::xcd::MifareWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartMifareWrite, (writeParameter, deviceHandle));
        }

        ::nn::Result GetAwakeTriggerReasonForLeftRail(::nn::sf::Out<::std::uint64_t> pOutParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForLeftRail, (pOutParameter));
        }

        ::nn::Result GetAwakeTriggerReasonForRightRail(::nn::sf::Out<::std::uint64_t> pOutParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForRightRail, (pOutParameter));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemServer
    {
    public:
        nn::Result GetDataFormat(nn::sf::Out<std::uint8_t> pOutDataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SetDataFormat(std::uint8_t dataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetMcuState(nn::sf::Out<std::uint8_t> pOutMcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SetMcuState(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetMcuVersionForNfc(nn::sf::Out<nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result CheckNfcDevicePower(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SetMcuStateImmediate(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SetNfcEvent(nn::sf::Out<nn::sf::NativeHandle> nfcEventHandle, nn::sf::Out<nn::sf::NativeHandle> nfcDetectEventHandle, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetNfcInfo(nn::sf::Out<nn::xcd::NfcInfo> pOutValue, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StartNfcDiscovery(nn::xcd::NfcDiscoveryParameter discoveryParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StopNfcDiscovery(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StartNtagRead(const nn::xcd::NtagReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StartNtagWrite(const nn::xcd::NtagWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result SendNfcRawData(const nn::xcd::NfcPassThruParameter& passThruParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result RegisterMifareKey(const nn::xcd::MifareKeyWriteParameter& keyWriteParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result ClearMifareKey(nn::xcd::MifareKeyClearParameter keyClearParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StartMifareRead(const nn::xcd::MifareReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StartMifareWrite(const nn::xcd::MifareWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetAwakeTriggerReasonForLeftRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT;
        nn::Result GetAwakeTriggerReasonForRightRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDataFormat(nn::sf::Out<std::uint8_t> pOutDataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetDataFormat(std::uint8_t dataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetMcuState(nn::sf::Out<std::uint8_t> pOutMcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetMcuState(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetMcuVersionForNfc(nn::sf::Out<nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result CheckNfcDevicePower(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetMcuStateImmediate(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetNfcEvent(nn::sf::Out<nn::sf::NativeHandle> nfcEventHandle, nn::sf::Out<nn::sf::NativeHandle> nfcDetectEventHandle, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNfcInfo(nn::sf::Out<nn::xcd::NfcInfo> pOutValue, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StartNfcDiscovery(nn::xcd::NfcDiscoveryParameter discoveryParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StopNfcDiscovery(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StartNtagRead(const nn::xcd::NtagReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StartNtagWrite(const nn::xcd::NtagWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SendNfcRawData(const nn::xcd::NfcPassThruParameter& passThruParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result RegisterMifareKey(const nn::xcd::MifareKeyWriteParameter& keyWriteParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ClearMifareKey(nn::xcd::MifareKeyClearParameter keyClearParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StartMifareRead(const nn::xcd::MifareReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StartMifareWrite(const nn::xcd::MifareWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAwakeTriggerReasonForLeftRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT;
    nn::Result GetAwakeTriggerReasonForRightRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::xcd::detail::ISystemServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDataFormat, (::nn::sf::Out<::std::uint8_t> pOutDataFormat, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDataFormat, (pOutDataFormat, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDataFormat, (::std::uint8_t dataFormat, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDataFormat, (dataFormat, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuState, (::nn::sf::Out<::std::uint8_t> pOutMcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMcuState, (pOutMcuState, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuState, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMcuState, (mcuState, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuVersionForNfc, (::nn::sf::Out<::nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMcuVersionForNfc, (pOutMcuVersionData, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNfcDevicePower, (::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckNfcDevicePower, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuStateImmediate, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMcuStateImmediate, (mcuState, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNfcEvent, (::nn::sf::Out<::nn::sf::NativeHandle> nfcEventHandle, ::nn::sf::Out<::nn::sf::NativeHandle> nfcDetectEventHandle, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNfcEvent, (nfcEventHandle, nfcDetectEventHandle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNfcInfo, (::nn::sf::Out<::nn::xcd::NfcInfo> pOutValue, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNfcInfo, (pOutValue, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNfcDiscovery, (::nn::xcd::NfcDiscoveryParameter discoveryParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartNfcDiscovery, (discoveryParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopNfcDiscovery, (::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopNfcDiscovery, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagRead, (const ::nn::xcd::NtagReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartNtagRead, (readParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagWrite, (const ::nn::xcd::NtagWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartNtagWrite, (writeParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendNfcRawData, (const ::nn::xcd::NfcPassThruParameter& passThruParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendNfcRawData, (passThruParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterMifareKey, (const ::nn::xcd::MifareKeyWriteParameter& keyWriteParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterMifareKey, (keyWriteParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearMifareKey, (::nn::xcd::MifareKeyClearParameter keyClearParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearMifareKey, (keyClearParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareRead, (const ::nn::xcd::MifareReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartMifareRead, (readParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareWrite, (const ::nn::xcd::MifareWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartMifareWrite, (writeParameter, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForLeftRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAwakeTriggerReasonForLeftRail, (pOutParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForRightRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAwakeTriggerReasonForRightRail, (pOutParameter));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::xcd::detail::ISystemServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::xcd::detail::ISystemServer))

    // nn::Result GetDataFormat(nn::sf::Out<std::uint8_t> pOutDataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDataFormat)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutDataFormat, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutDataFormat))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutDataFormat), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDataFormat)

    // nn::Result SetDataFormat(std::uint8_t dataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDataFormat)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataFormat, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (dataFormat, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataFormat), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDataFormat)

    // nn::Result GetMcuState(nn::sf::Out<std::uint8_t> pOutMcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMcuState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMcuState, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMcuState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMcuState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMcuState)

    // nn::Result SetMcuState(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMcuState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mcuState, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mcuState, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMcuState)

    // nn::Result GetMcuVersionForNfc(nn::sf::Out<nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMcuVersionForNfc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMcuVersionData, (::nn::xcd::McuVersionDataForNfc), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMcuVersionData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMcuVersionData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMcuVersionForNfc)

    // nn::Result CheckNfcDevicePower(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckNfcDevicePower)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckNfcDevicePower)

    // nn::Result SetMcuStateImmediate(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMcuStateImmediate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mcuState, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mcuState, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMcuStateImmediate)

    // nn::Result SetNfcEvent(nn::sf::Out<nn::sf::NativeHandle> nfcEventHandle, nn::sf::Out<nn::sf::NativeHandle> nfcDetectEventHandle, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNfcEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(nfcEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(nfcDetectEventHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(2, (nfcEventHandle, nfcDetectEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nfcEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nfcDetectEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNfcEvent)

    // nn::Result GetNfcInfo(nn::sf::Out<nn::xcd::NfcInfo> pOutValue, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNfcInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutValue, 0, (::nn::sf::Out<::nn::xcd::NfcInfo>), 2052, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNfcInfo)

    // nn::Result StartNfcDiscovery(nn::xcd::NfcDiscoveryParameter discoveryParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartNfcDiscovery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(discoveryParameter, (::nn::xcd::NfcDiscoveryParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (discoveryParameter, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(discoveryParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartNfcDiscovery)

    // nn::Result StopNfcDiscovery(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopNfcDiscovery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopNfcDiscovery)

    // nn::Result StartNtagRead(const nn::xcd::NtagReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartNtagRead)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(readParameter, (::nn::xcd::NtagReadParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (readParameter, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartNtagRead)

    // nn::Result StartNtagWrite(const nn::xcd::NtagWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartNtagWrite)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(writeParameter, 0, (const ::nn::xcd::NtagWriteParameter&), 1012, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (writeParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(writeParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartNtagWrite)

    // nn::Result SendNfcRawData(const nn::xcd::NfcPassThruParameter& passThruParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendNfcRawData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(passThruParameter, 0, (const ::nn::xcd::NfcPassThruParameter&), 536, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (passThruParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(passThruParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendNfcRawData)

    // nn::Result RegisterMifareKey(const nn::xcd::MifareKeyWriteParameter& keyWriteParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterMifareKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(keyWriteParameter, 0, (const ::nn::xcd::MifareKeyWriteParameter&), 100, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyWriteParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyWriteParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterMifareKey)

    // nn::Result ClearMifareKey(nn::xcd::MifareKeyClearParameter keyClearParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearMifareKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keyClearParameter, (::nn::xcd::MifareKeyClearParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (keyClearParameter, deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyClearParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearMifareKey)

    // nn::Result StartMifareRead(const nn::xcd::MifareReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartMifareRead)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(readParameter, 0, (const ::nn::xcd::MifareReadParameter&), 280, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (readParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartMifareRead)

    // nn::Result StartMifareWrite(const nn::xcd::MifareWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartMifareWrite)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(writeParameter, 0, (const ::nn::xcd::MifareWriteParameter&), 536, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (writeParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::xcd::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(writeParameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartMifareWrite)

    // nn::Result GetAwakeTriggerReasonForLeftRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAwakeTriggerReasonForLeftRail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutParameter, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutParameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAwakeTriggerReasonForLeftRail)

    // nn::Result GetAwakeTriggerReasonForRightRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAwakeTriggerReasonForRightRail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutParameter, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutParameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAwakeTriggerReasonForRightRail)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::DeviceHandle), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::McuVersionDataForNfc), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::NfcInfo), 2052, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::NfcDiscoveryParameter), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::NtagReadParameter), 40, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::NtagWriteParameter), 1012, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::NfcPassThruParameter), 536, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::MifareKeyWriteParameter), 100, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::MifareKeyClearParameter), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::MifareReadParameter), 280, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::MifareWriteParameter), 536, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::xcd::detail::ISystemServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::xcd::detail::ISystemServer))

    // nn::Result GetDataFormat(nn::sf::Out<std::uint8_t> pOutDataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDataFormat, (::nn::sf::Out<::std::uint8_t> pOutDataFormat, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDataFormat)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutDataFormat)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDataFormat)
    }

    // nn::Result SetDataFormat(std::uint8_t dataFormat, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDataFormat, (::std::uint8_t dataFormat, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDataFormat)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataFormat)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDataFormat)
    }

    // nn::Result GetMcuState(nn::sf::Out<std::uint8_t> pOutMcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuState, (::nn::sf::Out<::std::uint8_t> pOutMcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMcuState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMcuState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMcuState)
    }

    // nn::Result SetMcuState(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuState, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMcuState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMcuState)
    }

    // nn::Result GetMcuVersionForNfc(nn::sf::Out<nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMcuVersionForNfc, (::nn::sf::Out<::nn::xcd::McuVersionDataForNfc> pOutMcuVersionData, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMcuVersionForNfc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMcuVersionData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMcuVersionForNfc)
    }

    // nn::Result CheckNfcDevicePower(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNfcDevicePower, (::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckNfcDevicePower)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckNfcDevicePower)
    }

    // nn::Result SetMcuStateImmediate(std::uint8_t mcuState, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMcuStateImmediate, (::std::uint8_t mcuState, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMcuStateImmediate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMcuStateImmediate)
    }

    // nn::Result SetNfcEvent(nn::sf::Out<nn::sf::NativeHandle> nfcEventHandle, nn::sf::Out<nn::sf::NativeHandle> nfcDetectEventHandle, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNfcEvent, (::nn::sf::Out<::nn::sf::NativeHandle> nfcEventHandle, ::nn::sf::Out<::nn::sf::NativeHandle> nfcDetectEventHandle, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNfcEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nfcEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nfcDetectEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNfcEvent)
    }

    // nn::Result GetNfcInfo(nn::sf::Out<nn::xcd::NfcInfo> pOutValue, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNfcInfo, (::nn::sf::Out<::nn::xcd::NfcInfo> pOutValue, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNfcInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNfcInfo)
    }

    // nn::Result StartNfcDiscovery(nn::xcd::NfcDiscoveryParameter discoveryParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNfcDiscovery, (::nn::xcd::NfcDiscoveryParameter discoveryParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartNfcDiscovery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(discoveryParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartNfcDiscovery)
    }

    // nn::Result StopNfcDiscovery(nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopNfcDiscovery, (::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopNfcDiscovery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopNfcDiscovery)
    }

    // nn::Result StartNtagRead(const nn::xcd::NtagReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagRead, (const ::nn::xcd::NtagReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartNtagRead)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartNtagRead)
    }

    // nn::Result StartNtagWrite(const nn::xcd::NtagWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartNtagWrite, (const ::nn::xcd::NtagWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartNtagWrite)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(writeParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartNtagWrite)
    }

    // nn::Result SendNfcRawData(const nn::xcd::NfcPassThruParameter& passThruParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendNfcRawData, (const ::nn::xcd::NfcPassThruParameter& passThruParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendNfcRawData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(passThruParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendNfcRawData)
    }

    // nn::Result RegisterMifareKey(const nn::xcd::MifareKeyWriteParameter& keyWriteParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterMifareKey, (const ::nn::xcd::MifareKeyWriteParameter& keyWriteParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterMifareKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyWriteParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterMifareKey)
    }

    // nn::Result ClearMifareKey(nn::xcd::MifareKeyClearParameter keyClearParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearMifareKey, (::nn::xcd::MifareKeyClearParameter keyClearParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearMifareKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyClearParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearMifareKey)
    }

    // nn::Result StartMifareRead(const nn::xcd::MifareReadParameter& readParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareRead, (const ::nn::xcd::MifareReadParameter& readParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartMifareRead)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartMifareRead)
    }

    // nn::Result StartMifareWrite(const nn::xcd::MifareWriteParameter& writeParameter, nn::xcd::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMifareWrite, (const ::nn::xcd::MifareWriteParameter& writeParameter, ::nn::xcd::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartMifareWrite)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(writeParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartMifareWrite)
    }

    // nn::Result GetAwakeTriggerReasonForLeftRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForLeftRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAwakeTriggerReasonForLeftRail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAwakeTriggerReasonForLeftRail)
    }

    // nn::Result GetAwakeTriggerReasonForRightRail(nn::sf::Out<std::uint64_t> pOutParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAwakeTriggerReasonForRightRail, (::nn::sf::Out<::std::uint64_t> pOutParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAwakeTriggerReasonForRightRail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAwakeTriggerReasonForRightRail)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::xcd::detail::ISystemServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::xcd::detail::ISystemServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDataFormat)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDataFormat)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutDataFormat),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDataFormat)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDataFormat)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataFormat),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMcuState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMcuState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMcuState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMcuState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMcuState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mcuState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMcuVersionForNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMcuVersionForNfc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMcuVersionData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckNfcDevicePower)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckNfcDevicePower)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMcuStateImmediate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMcuStateImmediate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mcuState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNfcEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(nfcEventHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(nfcDetectEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNfcEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(nfcEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(nfcDetectEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNfcInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNfcInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartNfcDiscovery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartNfcDiscovery)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(discoveryParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopNfcDiscovery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopNfcDiscovery)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartNtagRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartNtagRead)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(readParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartNtagWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(writeParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartNtagWrite)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(writeParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendNfcRawData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(passThruParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendNfcRawData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(passThruParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterMifareKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyWriteParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterMifareKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyWriteParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearMifareKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearMifareKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keyClearParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartMifareRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(readParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartMifareRead)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(readParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartMifareWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(writeParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartMifareWrite)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(writeParameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAwakeTriggerReasonForLeftRail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAwakeTriggerReasonForLeftRail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAwakeTriggerReasonForRightRail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAwakeTriggerReasonForRightRail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDataFormat)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDataFormat)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMcuState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMcuState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMcuVersionForNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckNfcDevicePower)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMcuStateImmediate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNfcEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNfcInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartNfcDiscovery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopNfcDiscovery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartNtagRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartNtagWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendNfcRawData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterMifareKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearMifareKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartMifareRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartMifareWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAwakeTriggerReasonForLeftRail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAwakeTriggerReasonForRightRail)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::xcd::detail::ISystemServer))
