﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for 3D stereoscopic modes.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief 3D stereoscopic modes for displays.
     */
    enum StereoMode
    {
        StereoMode_None,         //!< Standard 2D display mode.
        StereoMode_FramePacking, //!< 3D implemented with frame packing.
        StereoMode_SideBySide,   //!< 3D implemented with side by side.
        StereoMode_TopAndBottom, //!< 3D implemented with top and bottom.
    };

}}
