﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_HipcClientProxyByName.h>

#include <type_traits>

namespace nn{ namespace vi{ namespace manager{

    struct ManagerServiceData;

    class DisplayManagerService
    {
    public:
        static const size_t ObjectCountMax = 10;
    public:
        typedef nn::visrv::sf::IApplicationDisplayService ApplicationDisplayServiceType;
        typedef nn::visrv::sf::ISystemDisplayService SystemDisplayServiceType;
        typedef nn::visrv::sf::IManagerDisplayService ManagerDisplayServiceType;
    public:
        DisplayManagerService() NN_NOEXCEPT;
        void Initialize(
            PolicyLevelType policyLevel,
            const nn::vi::ProxyName* pProxyName
        ) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // nvnflinger を初期化しない
        void InitializeMinimum(
            PolicyLevelType policyLevel,
            const nn::vi::ProxyName* pProxyName
        ) NN_NOEXCEPT;
        void FinalizeMinimum() NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> GetApplicationDisplayService() NN_NOEXCEPT
        {
            return m_pApplicationDisplayService;
        }

        nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService> GetSystemDisplayService() NN_NOEXCEPT
        {
            return m_pSystemDisplayService;
        }

        nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService> GetManagerDisplayService() NN_NOEXCEPT
        {
            return m_pManagerDisplayService;
        }

        ManagerServiceData* GetData() NN_NOEXCEPT
        {
            return reinterpret_cast<ManagerServiceData*>(&m_Storage[0]);
        }

    private:
        nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax>             m_ClientManager;
        nn::sf::ShimLibraryObjectHolder<nn::visrv::sf::IManagerRootService> m_RootServiceHolder;
        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>    m_pApplicationDisplayService;
        nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>         m_pSystemDisplayService;
        nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>        m_pManagerDisplayService;
        nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>             m_pRelayService;
        nn::vi::ProxyName m_ProxyName;
        NN_ALIGNAS(16) char m_Storage[32];
    };

}}}


