﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../vi_ImageTransform.h"
#include "../vi_LayerStack.h"

namespace nn{ namespace vi{ namespace fbshare{

    enum SharedTextureColorOption
    {
        SharedTextureColorOption_None = 0,
        SharedTextureColorOption_PreMultipledAlpha = (1 << 0),
    };

    enum SharedTextureAlphaOption
    {
        SharedTextureAlphaOption_None   = 0,
        SharedTextureAlphaOption_Opaque = (1 << 0),
    };

    typedef uint32_t SharedTextureColorOptionType;
    typedef uint32_t SharedTextureAlphaOptionType;

    struct SharedTextureOption
    {
        ImageTransformType           transform;
        SharedTextureColorOptionType colorOption;
        SharedTextureAlphaOptionType alphaOption;
        LayerStackFlagType           stacks;
    };

}}}
