﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/vi/native/vi_NativeType.h>
#include <nvn/nvn.h>

namespace nn{ namespace vi{ namespace fbshare{

    enum SharedTextureMemoryPoolState
    {
        SharedTextureMemoryPoolState_Invalid = 0,
        SharedTextureMemoryPoolState_Initialized,
    };

    enum SharedTextureMemoryPoolOption : uint32_t
    {
        SharedTextureMemoryPoolOption_None = 0,
        SharedTextureMemoryPoolOption_Compressible = (1 << 0),
    };

    class SharedTextureMemoryPool
    {
    public:
        SharedTextureMemoryPool() NN_NOEXCEPT;

        // @pre true
        bool IsInitialized() const NN_NOEXCEPT;

        // @pre IsInitialized
        bool IsCompressible() const NN_NOEXCEPT;

        // @pre IsInitialized
        size_t GetSize() const NN_NOEXCEPT;

        // @pre !IsInitialized
        nn::Result Initialize(NVNdevice* pDevice, nn::vi::native::NativeMemoryHandleId memId, size_t size, SharedTextureMemoryPoolOption option) NN_NOEXCEPT;

        // @pre IsInitialized
        void Finalize() NN_NOEXCEPT;

        // @pre IsInitialized
        NVNmemoryPool* GetNvnImportedMemoryPool() NN_NOEXCEPT;

    private:
        SharedTextureMemoryPoolState  m_State;
        SharedTextureMemoryPoolOption m_Option;
        uint64_t      m_MemoryHandle;
        size_t        m_MemorySize;
        NVNmemoryPool m_ImportedMemoryPool;
    };

}}}
