﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>

namespace nn{ namespace vi{ namespace fbshare{

    static const int SharedBufferTextureCountMax = 16;

    static const int NativeWindowTextureCountMin = 2;
    static const int NativeWindowTextureCountMax = 4;

    //! @brief 静的領域に共有フレームバッファを作成する際に指定するキーのデフォルト値。
    //! 現在、使用していない。
    static const uint64_t SharedBufferStaticStorageDefaultKey = 0;

    //! @brief 静的領域に作成する共有フレームバッファの枚数
    static const int SharedBufferStaticStorageFrameBufferCount = 4;

    //! @brief 共有フレームバッファに使用する TransferMemory のクライアント側属性
    static const nn::os::MemoryPermission SharedBufferMemoryPermission = nn::os::MemoryPermission_None;

}}}
