﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   USB::PD ライブラリの型や定数の定義
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace usb {
namespace pd {

/**
 * @brief クレードル VDM コマンド
 */
enum CradleVdmCommand
{
    CradleVdmCommand_Led                                    = 0,
    CradleVdmCommand_Dp2HdmiFwVersion                       = 1,
    CradleVdmCommand_PdcHFwVersion                          = 2,
    CradleVdmCommand_PdcAFwVersion                          = 3,
    CradleVdmCommand_DeviceState                            = 4,
    CradleVdmCommand_McuFwVersion                           = 5,
    CradleVdmCommand_McuFwUpdate                            = 6,
    CradleVdmCommand_McuSleepEnable                         = 7,
    CradleVdmCommand_UsbHubReset                            = 8,
    CradleVdmCommand_UsbHubVBusDetect                       = 9,

    CradleVdmCommand_Num
};

} // pd
} // usb
} // nn
