﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   USB::PD ドライバライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/usb/pd/usb_PdResult.h>
#include <nn/usb/pd/usb_PdType.h>

namespace nn {
namespace usb {
namespace pd {
namespace driver {

/**
 * @brief セッション用パラメータ
 */
struct SessionCore
{
    int       _sessionId;
};
struct Session : public SessionCore
{
};

/**
 * @brief USB::PD ドライバライブラリを初期化します。
 *
 * @post        ライブラリは初期化済の状態になります。
 * @details     USB::PD ドライバライブラリを初期化します。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief USB::PD ドライバライブラリを終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 * @details     USB::PD ドライバライブラリを終了します。
 */
void Finalize() NN_NOEXCEPT;

Result Sleep() NN_NOEXCEPT;
Result MinimumAwake() NN_NOEXCEPT;
Result FullAwake() NN_NOEXCEPT;

void OpenSession( Session* pOutSession ) NN_NOEXCEPT;
void CloseSession( Session* pSession ) NN_NOEXCEPT;

Result BindNoticeEvent( nn::os::SystemEventType* pEvent, const Session& session ) NN_NOEXCEPT;
Result UnbindNoticeEvent( const Session& session ) NN_NOEXCEPT;
Result GetStatus( Status* pOutValue, const Session& session ) NN_NOEXCEPT;
Result GetNotice( Notice* pOutValue, const Session& session ) NN_NOEXCEPT;
Result EnablePowerRequestNotice( const Session& session ) NN_NOEXCEPT;
Result DisablePowerRequestNotice( const Session& session ) NN_NOEXCEPT;
Result ReplyPowerRequest( const Session& session, bool isSuccess ) NN_NOEXCEPT;


} // driver
} // pd
} // usb
} // nn

