﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/usb/hs/sfdl/usb_HsClientIfSession.sfdl.h>
#include <nn/usb/usb_HostTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace usb { namespace hs { // NOLINT(whitespace/braces)

class IClientRootSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IClientRootSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IClientRootSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindClientProcess, (::nn::sf::NativeHandle&& processHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAllInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAvailableInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAcquiredInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateInterfaceAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::std::uint8_t filterIndex, const ::nn::usb::DeviceFilter& deviceFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyInterfaceAvailableEvent, (::std::uint8_t filterIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireUsbIf, (::nn::usb::InterfaceHandle ifHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientIfSession>> outSession, const ::nn::sf::OutBuffer& deviceProfile, const ::nn::sf::OutBuffer& interfaceProfile))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTestMode, (::std::uint32_t port, ::nn::usb::TestMode mode, ::std::int32_t offset, ::nn::sf::Out<::std::uint32_t> outStrength))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IClientRootSession)

        ::nn::Result BindClientProcess(::nn::sf::NativeHandle&& processHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindClientProcess, (::std::move(processHandle)));
        }

        ::nn::Result QueryAllInterfaces(::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAllInterfaces, (outIfCount, output, deviceFilter));
        }

        ::nn::Result QueryAvailableInterfaces(::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAvailableInterfaces, (outIfCount, output, deviceFilter));
        }

        ::nn::Result QueryAcquiredInterfaces(::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAcquiredInterfaces, (outIfCount, output));
        }

        ::nn::Result CreateInterfaceAvailableEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::std::uint8_t filterIndex, const ::nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateInterfaceAvailableEvent, (eventHandle, filterIndex, deviceFilter));
        }

        ::nn::Result DestroyInterfaceAvailableEvent(::std::uint8_t filterIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyInterfaceAvailableEvent, (filterIndex));
        }

        ::nn::Result GetInterfaceStateChangeEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterfaceStateChangeEvent, (eventHandle));
        }

        ::nn::Result AcquireUsbIf(::nn::usb::InterfaceHandle ifHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientIfSession>> outSession, const ::nn::sf::OutBuffer& deviceProfile, const ::nn::sf::OutBuffer& interfaceProfile) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireUsbIf, (ifHandle, outSession, deviceProfile, interfaceProfile));
        }

        ::nn::Result SetTestMode(::std::uint32_t port, ::nn::usb::TestMode mode, ::std::int32_t offset, ::nn::sf::Out<::std::uint32_t> outStrength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTestMode, (port, mode, offset, outStrength));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IClientRootSession
    {
    public:
        nn::Result BindClientProcess(nn::sf::NativeHandle&& processHandle) NN_NOEXCEPT;
        nn::Result QueryAllInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
        nn::Result QueryAvailableInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
        nn::Result QueryAcquiredInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output) NN_NOEXCEPT;
        nn::Result CreateInterfaceAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle, std::uint8_t filterIndex, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
        nn::Result DestroyInterfaceAvailableEvent(std::uint8_t filterIndex) NN_NOEXCEPT;
        nn::Result GetInterfaceStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
        nn::Result AcquireUsbIf(nn::usb::InterfaceHandle ifHandle, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientIfSession>> outSession, const nn::sf::OutBuffer& deviceProfile, const nn::sf::OutBuffer& interfaceProfile) NN_NOEXCEPT;
        nn::Result SetTestMode(std::uint32_t port, nn::usb::TestMode mode, std::int32_t offset, nn::sf::Out<std::uint32_t> outStrength) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result BindClientProcess(nn::sf::NativeHandle&& processHandle) NN_NOEXCEPT;
    nn::Result QueryAllInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
    nn::Result QueryAvailableInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
    nn::Result QueryAcquiredInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output) NN_NOEXCEPT;
    nn::Result CreateInterfaceAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle, std::uint8_t filterIndex, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT;
    nn::Result DestroyInterfaceAvailableEvent(std::uint8_t filterIndex) NN_NOEXCEPT;
    nn::Result GetInterfaceStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    nn::Result AcquireUsbIf(nn::usb::InterfaceHandle ifHandle, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientIfSession>> outSession, const nn::sf::OutBuffer& deviceProfile, const nn::sf::OutBuffer& interfaceProfile) NN_NOEXCEPT;
    nn::Result SetTestMode(std::uint32_t port, nn::usb::TestMode mode, std::int32_t offset, nn::sf::Out<std::uint32_t> outStrength) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::usb::hs::IClientRootSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindClientProcess, (::nn::sf::NativeHandle&& processHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindClientProcess, (::std::move(processHandle)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAllInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAllInterfaces, (outIfCount, output, deviceFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAvailableInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAvailableInterfaces, (outIfCount, output, deviceFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAcquiredInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAcquiredInterfaces, (outIfCount, output));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateInterfaceAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::std::uint8_t filterIndex, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateInterfaceAvailableEvent, (eventHandle, filterIndex, deviceFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyInterfaceAvailableEvent, (::std::uint8_t filterIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyInterfaceAvailableEvent, (filterIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterfaceStateChangeEvent, (eventHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireUsbIf, (::nn::usb::InterfaceHandle ifHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientIfSession>> outSession, const ::nn::sf::OutBuffer& deviceProfile, const ::nn::sf::OutBuffer& interfaceProfile))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireUsbIf, (ifHandle, outSession, deviceProfile, interfaceProfile));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTestMode, (::std::uint32_t port, ::nn::usb::TestMode mode, ::std::int32_t offset, ::nn::sf::Out<::std::uint32_t> outStrength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTestMode, (port, mode, offset, outStrength));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::usb::hs::IClientRootSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::usb::hs::IClientRootSession))

    // nn::Result BindClientProcess(nn::sf::NativeHandle&& processHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindClientProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindClientProcess)

    // nn::Result QueryAllInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAllInterfaces)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceFilter, (::nn::usb::DeviceFilter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIfCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIfCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIfCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAllInterfaces)

    // nn::Result QueryAvailableInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAvailableInterfaces)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceFilter, (::nn::usb::DeviceFilter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIfCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIfCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIfCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAvailableInterfaces)

    // nn::Result QueryAcquiredInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAcquiredInterfaces)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIfCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIfCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIfCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAcquiredInterfaces)

    // nn::Result CreateInterfaceAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle, std::uint8_t filterIndex, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateInterfaceAvailableEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filterIndex, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceFilter, (::nn::usb::DeviceFilter), 2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filterIndex, deviceFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(18)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filterIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateInterfaceAvailableEvent)

    // nn::Result DestroyInterfaceAvailableEvent(std::uint8_t filterIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyInterfaceAvailableEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filterIndex, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filterIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filterIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyInterfaceAvailableEvent)

    // nn::Result GetInterfaceStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterfaceStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterfaceStateChangeEvent)

    // nn::Result AcquireUsbIf(nn::usb::InterfaceHandle ifHandle, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientIfSession>> outSession, const nn::sf::OutBuffer& deviceProfile, const nn::sf::OutBuffer& interfaceProfile) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireUsbIf)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(deviceProfile, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(interfaceProfile, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (deviceProfile, interfaceProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ifHandle, (::nn::usb::InterfaceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ifHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ifHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interfaceProfile)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireUsbIf)

    // nn::Result SetTestMode(std::uint32_t port, nn::usb::TestMode mode, std::int32_t offset, nn::sf::Out<std::uint32_t> outStrength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTestMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::nn::usb::TestMode), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (port, mode, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStrength, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outStrength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStrength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTestMode)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::DeviceFilter), 16, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::InterfaceHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::TestMode), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::usb::hs::IClientRootSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::usb::hs::IClientRootSession))

    // nn::Result BindClientProcess(nn::sf::NativeHandle&& processHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindClientProcess, (::nn::sf::NativeHandle&& processHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindClientProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindClientProcess)
    }

    // nn::Result QueryAllInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAllInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAllInterfaces)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIfCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAllInterfaces)
    }

    // nn::Result QueryAvailableInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAvailableInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAvailableInterfaces)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIfCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAvailableInterfaces)
    }

    // nn::Result QueryAcquiredInterfaces(nn::sf::Out<std::int32_t> outIfCount, const nn::sf::OutBuffer& output) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAcquiredInterfaces, (::nn::sf::Out<::std::int32_t> outIfCount, const ::nn::sf::OutBuffer& output))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAcquiredInterfaces)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIfCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAcquiredInterfaces)
    }

    // nn::Result CreateInterfaceAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle, std::uint8_t filterIndex, const nn::usb::DeviceFilter& deviceFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateInterfaceAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::std::uint8_t filterIndex, const ::nn::usb::DeviceFilter& deviceFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateInterfaceAvailableEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filterIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateInterfaceAvailableEvent)
    }

    // nn::Result DestroyInterfaceAvailableEvent(std::uint8_t filterIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyInterfaceAvailableEvent, (::std::uint8_t filterIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyInterfaceAvailableEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filterIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyInterfaceAvailableEvent)
    }

    // nn::Result GetInterfaceStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterfaceStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterfaceStateChangeEvent)
    }

    // nn::Result AcquireUsbIf(nn::usb::InterfaceHandle ifHandle, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientIfSession>> outSession, const nn::sf::OutBuffer& deviceProfile, const nn::sf::OutBuffer& interfaceProfile) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireUsbIf, (::nn::usb::InterfaceHandle ifHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientIfSession>> outSession, const ::nn::sf::OutBuffer& deviceProfile, const ::nn::sf::OutBuffer& interfaceProfile))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireUsbIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ifHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interfaceProfile)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireUsbIf)
    }

    // nn::Result SetTestMode(std::uint32_t port, nn::usb::TestMode mode, std::int32_t offset, nn::sf::Out<std::uint32_t> outStrength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTestMode, (::std::uint32_t port, ::nn::usb::TestMode mode, ::std::int32_t offset, ::nn::sf::Out<::std::uint32_t> outStrength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTestMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStrength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTestMode)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::usb::hs::IClientRootSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::usb::hs::IClientRootSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindClientProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindClientProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAllInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAllInterfaces)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIfCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAvailableInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAvailableInterfaces)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIfCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAcquiredInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAcquiredInterfaces)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIfCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateInterfaceAvailableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateInterfaceAvailableEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filterIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyInterfaceAvailableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyInterfaceAvailableEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filterIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterfaceStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterfaceStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireUsbIf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(deviceProfile)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(interfaceProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::usb::hs::IClientIfSession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireUsbIf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ifHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(deviceProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(interfaceProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTestMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTestMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStrength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindClientProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAllInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAvailableInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAcquiredInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateInterfaceAvailableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyInterfaceAvailableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterfaceStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireUsbIf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTestMode)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::usb::hs::IClientRootSession))
