﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/usb/hs/sfdl/usb_HsClientEpSession.sfdl.h>
#include <nn/usb/usb_HostTypes.h>
#include <nn/usb/usb_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace usb { namespace hs { // NOLINT(whitespace/braces)

class IClientIfSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IClientIfSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IClientIfSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandler))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterface, (const ::nn::sf::OutBuffer& dataOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlternateInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentFrame, (::nn::sf::Out<::nn::usb::FrameNumber> outFrameNumber))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CtrlXferAsync, (::std::uint8_t bmRequestType, ::std::uint8_t bRequest, ::std::uint16_t wValue, ::std::uint16_t wIndex, ::std::uint16_t wLength, ::std::uint64_t procVa))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferReport, (const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetDevice)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenUsbEp, (::nn::usb::UsbEndpointType epType, ::nn::usb::EndpointNumber epNumber, ::nn::usb::UsbEndpointDirection epDirection, ::std::uint16_t maxUrb, ::std::uint32_t maxXferSize, ::nn::sf::Out<::nn::usb::UsbEndpointDescriptor> outDescriptor, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientEpSession>> outSession))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IClientIfSession)

        ::nn::Result GetStateChangeEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandler) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (eventHandler));
        }

        ::nn::Result SetInterface(::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInterface, (bAlternateSetting, dataOut));
        }

        ::nn::Result GetInterface(const ::nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterface, (dataOut));
        }

        ::nn::Result GetAlternateInterface(::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlternateInterface, (bAlternateSetting, dataOut));
        }

        ::nn::Result GetCurrentFrame(::nn::sf::Out<::nn::usb::FrameNumber> outFrameNumber) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentFrame, (outFrameNumber));
        }

        ::nn::Result CtrlXferAsync(::std::uint8_t bmRequestType, ::std::uint8_t bRequest, ::std::uint16_t wValue, ::std::uint16_t wIndex, ::std::uint16_t wLength, ::std::uint64_t procVa) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CtrlXferAsync, (bmRequestType, bRequest, wValue, wIndex, wLength, procVa));
        }

        ::nn::Result GetCtrlXferCompletionEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCtrlXferCompletionEvent, (eventHandle));
        }

        ::nn::Result GetCtrlXferReport(const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCtrlXferReport, (buffer));
        }

        ::nn::Result ResetDevice() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetDevice);
        }

        ::nn::Result OpenUsbEp(::nn::usb::UsbEndpointType epType, ::nn::usb::EndpointNumber epNumber, ::nn::usb::UsbEndpointDirection epDirection, ::std::uint16_t maxUrb, ::std::uint32_t maxXferSize, ::nn::sf::Out<::nn::usb::UsbEndpointDescriptor> outDescriptor, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientEpSession>> outSession) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenUsbEp, (epType, epNumber, epDirection, maxUrb, maxXferSize, outDescriptor, outSession));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IClientIfSession
    {
    public:
        nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandler) NN_NOEXCEPT;
        nn::Result SetInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
        nn::Result GetInterface(const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
        nn::Result GetAlternateInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
        nn::Result GetCurrentFrame(nn::sf::Out<nn::usb::FrameNumber> outFrameNumber) NN_NOEXCEPT;
        nn::Result CtrlXferAsync(std::uint8_t bmRequestType, std::uint8_t bRequest, std::uint16_t wValue, std::uint16_t wIndex, std::uint16_t wLength, std::uint64_t procVa) NN_NOEXCEPT;
        nn::Result GetCtrlXferCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
        nn::Result GetCtrlXferReport(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result ResetDevice() NN_NOEXCEPT;
        nn::Result OpenUsbEp(nn::usb::UsbEndpointType epType, nn::usb::EndpointNumber epNumber, nn::usb::UsbEndpointDirection epDirection, std::uint16_t maxUrb, std::uint32_t maxXferSize, nn::sf::Out<nn::usb::UsbEndpointDescriptor> outDescriptor, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientEpSession>> outSession) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandler) NN_NOEXCEPT;
    nn::Result SetInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
    nn::Result GetInterface(const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
    nn::Result GetAlternateInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT;
    nn::Result GetCurrentFrame(nn::sf::Out<nn::usb::FrameNumber> outFrameNumber) NN_NOEXCEPT;
    nn::Result CtrlXferAsync(std::uint8_t bmRequestType, std::uint8_t bRequest, std::uint16_t wValue, std::uint16_t wIndex, std::uint16_t wLength, std::uint64_t procVa) NN_NOEXCEPT;
    nn::Result GetCtrlXferCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    nn::Result GetCtrlXferReport(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result ResetDevice() NN_NOEXCEPT;
    nn::Result OpenUsbEp(nn::usb::UsbEndpointType epType, nn::usb::EndpointNumber epNumber, nn::usb::UsbEndpointDirection epDirection, std::uint16_t maxUrb, std::uint32_t maxXferSize, nn::sf::Out<nn::usb::UsbEndpointDescriptor> outDescriptor, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientEpSession>> outSession) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::usb::hs::IClientIfSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandler))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateChangeEvent, (eventHandler));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInterface, (bAlternateSetting, dataOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterface, (const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterface, (dataOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlternateInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlternateInterface, (bAlternateSetting, dataOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentFrame, (::nn::sf::Out<::nn::usb::FrameNumber> outFrameNumber))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentFrame, (outFrameNumber));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CtrlXferAsync, (::std::uint8_t bmRequestType, ::std::uint8_t bRequest, ::std::uint16_t wValue, ::std::uint16_t wIndex, ::std::uint16_t wLength, ::std::uint64_t procVa))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CtrlXferAsync, (bmRequestType, bRequest, wValue, wIndex, wLength, procVa));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCtrlXferCompletionEvent, (eventHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferReport, (const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCtrlXferReport, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetDevice)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetDevice);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenUsbEp, (::nn::usb::UsbEndpointType epType, ::nn::usb::EndpointNumber epNumber, ::nn::usb::UsbEndpointDirection epDirection, ::std::uint16_t maxUrb, ::std::uint32_t maxXferSize, ::nn::sf::Out<::nn::usb::UsbEndpointDescriptor> outDescriptor, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientEpSession>> outSession))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenUsbEp, (epType, epNumber, epDirection, maxUrb, maxXferSize, outDescriptor, outSession));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::usb::hs::IClientIfSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::usb::hs::IClientIfSession))

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandler) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandler, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandler))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandler)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateChangeEvent)

    // nn::Result SetInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (dataOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bAlternateSetting, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bAlternateSetting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bAlternateSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInterface)

    // nn::Result GetInterface(const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (dataOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterface)

    // nn::Result GetAlternateInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlternateInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (dataOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bAlternateSetting, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bAlternateSetting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bAlternateSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlternateInterface)

    // nn::Result GetCurrentFrame(nn::sf::Out<nn::usb::FrameNumber> outFrameNumber) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFrameNumber, (::nn::usb::FrameNumber), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFrameNumber))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFrameNumber)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentFrame)

    // nn::Result CtrlXferAsync(std::uint8_t bmRequestType, std::uint8_t bRequest, std::uint16_t wValue, std::uint16_t wIndex, std::uint16_t wLength, std::uint64_t procVa) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CtrlXferAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bmRequestType, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bRequest, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(wValue, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(wIndex, (::std::uint16_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(wLength, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(procVa, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (bmRequestType, bRequest, wValue, wIndex, wLength, procVa))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bmRequestType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bRequest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(wValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(wIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(wLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(procVa)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CtrlXferAsync)

    // nn::Result GetCtrlXferCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCtrlXferCompletionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCtrlXferCompletionEvent)

    // nn::Result GetCtrlXferReport(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCtrlXferReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCtrlXferReport)

    // nn::Result ResetDevice() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetDevice)

    // nn::Result OpenUsbEp(nn::usb::UsbEndpointType epType, nn::usb::EndpointNumber epNumber, nn::usb::UsbEndpointDirection epDirection, std::uint16_t maxUrb, std::uint32_t maxXferSize, nn::sf::Out<nn::usb::UsbEndpointDescriptor> outDescriptor, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientEpSession>> outSession) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenUsbEp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxUrb, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(epType, (::nn::usb::UsbEndpointType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(epNumber, (::nn::usb::EndpointNumber), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(epDirection, (::nn::usb::UsbEndpointDirection), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxXferSize, (::std::uint32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (maxUrb, epType, epNumber, epDirection, maxXferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDescriptor, (::nn::usb::UsbEndpointDescriptor), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outDescriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(epType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(epNumber), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(epDirection), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxUrb), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxXferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDescriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenUsbEp)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::FrameNumber), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::UsbEndpointType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::EndpointNumber), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::UsbEndpointDirection), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::UsbEndpointDescriptor), 7, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::usb::hs::IClientIfSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::usb::hs::IClientIfSession))

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandler) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandler))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandler)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateChangeEvent)
    }

    // nn::Result SetInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bAlternateSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInterface)
    }

    // nn::Result GetInterface(const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterface, (const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterface)
    }

    // nn::Result GetAlternateInterface(std::uint8_t bAlternateSetting, const nn::sf::OutBuffer& dataOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlternateInterface, (::std::uint8_t bAlternateSetting, const ::nn::sf::OutBuffer& dataOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlternateInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bAlternateSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlternateInterface)
    }

    // nn::Result GetCurrentFrame(nn::sf::Out<nn::usb::FrameNumber> outFrameNumber) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentFrame, (::nn::sf::Out<::nn::usb::FrameNumber> outFrameNumber))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFrameNumber)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentFrame)
    }

    // nn::Result CtrlXferAsync(std::uint8_t bmRequestType, std::uint8_t bRequest, std::uint16_t wValue, std::uint16_t wIndex, std::uint16_t wLength, std::uint64_t procVa) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CtrlXferAsync, (::std::uint8_t bmRequestType, ::std::uint8_t bRequest, ::std::uint16_t wValue, ::std::uint16_t wIndex, ::std::uint16_t wLength, ::std::uint64_t procVa))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CtrlXferAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bmRequestType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(wValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(wIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(wLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(procVa)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CtrlXferAsync)
    }

    // nn::Result GetCtrlXferCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCtrlXferCompletionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCtrlXferCompletionEvent)
    }

    // nn::Result GetCtrlXferReport(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlXferReport, (const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCtrlXferReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCtrlXferReport)
    }

    // nn::Result ResetDevice() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetDevice)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetDevice)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetDevice)
    }

    // nn::Result OpenUsbEp(nn::usb::UsbEndpointType epType, nn::usb::EndpointNumber epNumber, nn::usb::UsbEndpointDirection epDirection, std::uint16_t maxUrb, std::uint32_t maxXferSize, nn::sf::Out<nn::usb::UsbEndpointDescriptor> outDescriptor, nn::sf::Out<nn::sf::SharedPointer<nn::usb::hs::IClientEpSession>> outSession) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenUsbEp, (::nn::usb::UsbEndpointType epType, ::nn::usb::EndpointNumber epNumber, ::nn::usb::UsbEndpointDirection epDirection, ::std::uint16_t maxUrb, ::std::uint32_t maxXferSize, ::nn::sf::Out<::nn::usb::UsbEndpointDescriptor> outDescriptor, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::usb::hs::IClientEpSession>> outSession))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenUsbEp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(epType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(epNumber)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(epDirection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxUrb)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxXferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDescriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenUsbEp)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::usb::hs::IClientIfSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::usb::hs::IClientIfSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandler)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandler)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bAlternateSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlternateInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlternateInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bAlternateSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFrameNumber)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CtrlXferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CtrlXferAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bmRequestType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bRequest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(wValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(wIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(wLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(procVa)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCtrlXferCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCtrlXferCompletionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCtrlXferReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCtrlXferReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenUsbEp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::usb::hs::IClientEpSession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenUsbEp)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(epType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(epNumber),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(epDirection),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxUrb),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxXferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDescriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlternateInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CtrlXferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCtrlXferCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCtrlXferReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenUsbEp)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::usb::hs::IClientIfSession))
