﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_ResultBase.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>

#include <nn/updater/updater.h>
#include <nn/updater/updater_Result.h>
#include <nn/crypto/crypto_Sha256Generator.h>


namespace nn { namespace updater {

enum class UpdatePhase
{
    Phase1 = 1, // break package1 sub
    Phase2 = 2, // break package1 sub & package2 sub
    Phase3 = 3, // break bct sub & package1 sub & package2 sub
    Phase4 = 4, // break bct main, package1 main, package2 main.
    Phase5 = 5, // break package1 main, package2 main.
    Phase6 = 6, // break package1 main
};
struct BootImageHashes
{
    char bctMain[crypto::Sha256Generator::HashSize];
    char bctSub[crypto::Sha256Generator::HashSize];
    char package1Main[crypto::Sha256Generator::HashSize];
    char package1Sub[crypto::Sha256Generator::HashSize];
    char package2Main[crypto::Sha256Generator::HashSize];
    char package2Sub[crypto::Sha256Generator::HashSize];

    // BootImagePackage から読んだ値
    char bctFile[crypto::Sha256Generator::HashSize];
    char package1File[crypto::Sha256Generator::HashSize];
    char package2File[crypto::Sha256Generator::HashSize];

    size_t bctSize;
    size_t package1Size;
    size_t package2Size;
};

Result SetBootImagesIntermediatePhase(TargetBootMode mode, UpdatePhase phase, void* workBuffer, size_t workSize) NN_NOEXCEPT;

Result GetBootImageHash(BootImageHashes* pOutHashes, TargetBootMode mode, void* workBuffer, size_t workSize, BootImageUpdateType bootImageUpdateType) NN_NOEXCEPT;

}}

